% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_gnm_graph.R
\name{add_gnm_graph}
\alias{add_gnm_graph}
\title{Add a G(n, m) Erdos-Renyi graph}
\usage{
add_gnm_graph(graph, n, m, loops = FALSE, type = NULL, label = TRUE,
  rel = NULL, node_aes = NULL, edge_aes = NULL, node_data = NULL,
  edge_data = NULL, set_seed = NULL)
}
\arguments{
\item{graph}{a graph object of
class \code{dgr_graph}.}

\item{n}{the number of nodes
comprising the generated graph.}

\item{m}{the number of edges
in the generated graph.}

\item{loops}{a logical value
(default is \code{FALSE}) that
governs whether loops are
allowed to be created.}

\item{type}{an optional string that
describes the entity type for all the
nodes to be added.}

\item{label}{a boolean value where
setting to \code{TRUE} ascribes node
IDs to the label and \code{FALSE}
yields a blank label.}

\item{rel}{an optional string for
providing a relationship label to all
edges to be added.}

\item{node_aes}{an optional list
of named vectors comprising node
aesthetic attributes. The helper
function \code{node_aes()} is
strongly recommended for use here
as it contains arguments for each
of the accepted node aesthetic
attributes (e.g., \code{shape},
\code{style}, \code{color},
\code{fillcolor}).}

\item{edge_aes}{an optional list
of named vectors comprising edge
aesthetic attributes. The helper
function \code{edge_aes()} is
strongly recommended for use here
as it contains arguments for each
of the accepted edge aesthetic
attributes (e.g., \code{shape},
\code{style}, \code{penwidth},
\code{color}).}

\item{node_data}{an optional list
of named vectors comprising node
data attributes. The helper
function \code{node_data()} is
strongly recommended for use here
as it helps bind data specifically
to the created nodes.}

\item{edge_data}{an optional list
of named vectors comprising edge
data attributes. The helper function
\code{edge_data()} is strongly
recommended for use here as it helps
bind data specifically to the
created edges.}

\item{set_seed}{supplying a
value sets a random seed of the
\code{Mersenne-Twister}
implementation.}
}
\description{
To an existing
graph object, add a graph built
according to the Erdos-Renyi
G(n, m) model. This uses the
same constant probability when
creating the fixed number of
edges. Thus for \code{n} nodes
there will be \code{m} edges and,
if the \code{loops} argument is
set as \code{TRUE}, then random
loop edges will be part of
\code{m}.
}
\examples{
# Create an undirected GNM
# graph with 100 nodes and
# 120 edges
gnm_graph <-
  create_graph(
    directed = FALSE) \%>\%
  add_gnm_graph(
    n = 100,
    m = 120)

# Get a count of nodes
gnm_graph \%>\%
  count_nodes()

# Get a count of edges
gnm_graph \%>\%
  count_edges()
}
