% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_s_connected_cmpts.R
\name{count_s_connected_cmpts}
\alias{count_s_connected_cmpts}
\title{Get the number of strongly-connected components}
\usage{
count_s_connected_cmpts(graph)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}
}
\value{
a single integer value representing the
number of strongly-connected graph components.
}
\description{
Get the number of strongly-connected
components in the graph.
}
\examples{
# Create a graph and add
# several graph islands
graph <-
  create_graph() \%>\%
  add_islands_graph(
    n_islands = 4,
    island_size = 10,
    p = 1/5,
    edges_between = 1,
    set_seed = 23)

# Get a count of strongly-connected
# components in the graph
graph \%>\%
  count_s_connected_cmpts()
}
