% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recode_edge_attrs.R
\name{recode_edge_attrs}
\alias{recode_edge_attrs}
\title{Recode a set of edge attribute values}
\usage{
recode_edge_attrs(
  graph,
  edge_attr_from,
  ...,
  otherwise = NULL,
  edge_attr_to = NULL
)
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}

\item{edge_attr_from}{The name of the edge attribute column from which values
will be recoded.}

\item{...}{Single-length character vectors with the recoding instructions.
The first component should have the value to replace and the second should
have the replacement value (in the form \verb{"[to_replace] -> [replacement]", ...}).}

\item{otherwise}{An optional single value for recoding any unmatched values.}

\item{edge_attr_to}{An optional name of a new edge attribute to which the
recoded values will be applied. This will retain the original edge
attribute and its values.}
}
\value{
A graph object of class \code{dgr_graph}.
}
\description{
Within a graph's internal edge data frame (edf), recode character or numeric
edge attribute values. Optionally, one can specify a replacement value for
any unmatched mappings.
}
\examples{
# Create a random graph using the
# `add_gnm_graph()` function
graph <-
  create_graph() \%>\%
  add_gnm_graph(
    n = 4,
    m = 6,
    set_seed = 23) \%>\%
  set_edge_attrs(
    edge_attr = rel,
    values = c("a", "b", "a",
               "c", "b", "d"))

# Get the graph's internal edf
# to show which edge attributes
# are available
graph \%>\% get_edge_df()

# Recode the `rel` node
# attribute, creating a new edge
# attribute called `penwidth`;
# here, `a` is recoded to `1.0`,
# `b` maps to `1.5`, and all
# other values become `0.5`
graph <-
  graph \%>\%
  recode_edge_attrs(
    edge_attr_from = rel,
    "a -> 1.0",
    "b -> 1.5",
    otherwise = 0.5,
    edge_attr_to = penwidth)

# Get the graph's internal edf
# to show that the node
# attribute values had been
# recoded and copied into a
# new node attribute
graph \%>\% get_edge_df()

}
\seealso{
Other Edge creation and removal: 
\code{\link{add_edge_clone}()},
\code{\link{add_edge_df}()},
\code{\link{add_edges_from_table}()},
\code{\link{add_edges_w_string}()},
\code{\link{add_edge}()},
\code{\link{add_forward_edges_ws}()},
\code{\link{add_reverse_edges_ws}()},
\code{\link{copy_edge_attrs}()},
\code{\link{create_edge_df}()},
\code{\link{delete_edges_ws}()},
\code{\link{delete_edge}()},
\code{\link{delete_loop_edges_ws}()},
\code{\link{drop_edge_attrs}()},
\code{\link{edge_data}()},
\code{\link{join_edge_attrs}()},
\code{\link{mutate_edge_attrs_ws}()},
\code{\link{mutate_edge_attrs}()},
\code{\link{rename_edge_attrs}()},
\code{\link{rescale_edge_attrs}()},
\code{\link{rev_edge_dir_ws}()},
\code{\link{rev_edge_dir}()},
\code{\link{set_edge_attr_to_display}()},
\code{\link{set_edge_attrs_ws}()},
\code{\link{set_edge_attrs}()}
}
\concept{Edge creation and removal}
