% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout_nodes_w_string.R
\name{layout_nodes_w_string}
\alias{layout_nodes_w_string}
\title{Layout nodes using a text-based schematic}
\usage{
layout_nodes_w_string(
  graph,
  layout,
  nodes,
  sort = NULL,
  width = 8,
  height = 8,
  ll = c(0, 0)
)
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}

\item{layout}{A layout character string that provides a schematic for the
layout. This consists of a rectangular collection of \code{-} characters (for no
node placement), and numbers from \code{1} to \code{9} (representing different
groupings of nodes, further described in the \code{nodes} argument).}

\item{nodes}{A named vector of the form: \code{c("1" = "[node_attr]:[value]", ...)}. The LHS corresponds to the numbers used in the \code{layout} schematic.
The RHS provides a shorthand for the node attribute and a value for
grouping together nodes (separated by a colon). For instance, with
\code{"type:a"} in the RHS (and \code{"1"} in the LHS) we would target all nodes with
a \code{type} attribute equal to \code{a} for positioning in the graph as described
by the \code{1}s in the \code{layout}.}

\item{sort}{An optional sorting method to apply to the collection of nodes
before assigning positional information. Like \code{nodes}, this is a named
vector of the form: \code{c("1" = "[node_attr]:asc|desc", ...)}. The \code{node_attr}
in this case should be different than that used in \code{nodes}. Ideally, this
node attribute should have unique values. Choose either \code{asc} or \code{desc}
right of the colon for ascending or descending sorts.}

\item{width}{The width of the \code{layout} diagram.}

\item{height}{The height of the \code{layout} diagram.}

\item{ll}{A vector describing the the lower-left coordinates of the \code{layout}}
}
\value{
A graph object of class \code{dgr_graph}.
}
\description{
Layout one or several groups of nodes using a text-based schematic. The
option is available to apply sorting to each of the groups.
}
\examples{
# Create a graph with unique labels and
# several node `type` groupings
graph <-
  create_graph() \%>\%
  add_node(type = "a", label = "a") \%>\%
  add_node(type = "a", label = "b") \%>\%
  add_node(type = "b", label = "c") \%>\%
  add_node(type = "b", label = "d") \%>\%
  add_node(type = "b", label = "e") \%>\%
  add_node(type = "c", label = "f") \%>\%
  add_node(type = "c", label = "g")

# Define a 'layout' for groups of nodes
# using a text string (dashes are empty
# grid cells, numbers--representing
# ad-hoc groupings--correspond to
# individual nodes); here, define a layout
# with 3 groups of nodes
layout <-
"
1--------
1--------
---222---
--------3
--------3
"

# Use the `layout` along with what nodes
# the numbers correspond to in the graph
# with the `nodes` named vectors; the
# optional `sort` vector describes how
# we should sort the collection of node
# before adding position information
graph <-
  graph \%>\%
  layout_nodes_w_string(
    layout = layout,
    nodes = c("1" = "type:a",
              "2" = "type:b",
              "3" = "type:c"),
    sort = c("1" = "label:asc",
             "2" = "label:desc",
             "3" = "label:desc"))

# Show the graph's node data frame
# to confirm that `x` and `y` values
# were added to each of the nodes
graph \%>\% get_node_df()
}
\seealso{
Other Node creation and removal: 
\code{\link{add_n_node_clones}()},
\code{\link{add_n_nodes_ws}()},
\code{\link{add_n_nodes}()},
\code{\link{add_node_clones_ws}()},
\code{\link{add_node_df}()},
\code{\link{add_nodes_from_df_cols}()},
\code{\link{add_nodes_from_table}()},
\code{\link{add_node}()},
\code{\link{colorize_node_attrs}()},
\code{\link{copy_node_attrs}()},
\code{\link{create_node_df}()},
\code{\link{delete_nodes_ws}()},
\code{\link{delete_node}()},
\code{\link{drop_node_attrs}()},
\code{\link{join_node_attrs}()},
\code{\link{mutate_node_attrs_ws}()},
\code{\link{mutate_node_attrs}()},
\code{\link{node_data}()},
\code{\link{recode_node_attrs}()},
\code{\link{rename_node_attrs}()},
\code{\link{rescale_node_attrs}()},
\code{\link{set_node_attr_to_display}()},
\code{\link{set_node_attr_w_fcn}()},
\code{\link{set_node_attrs_ws}()},
\code{\link{set_node_attrs}()},
\code{\link{set_node_position}()}
}
\concept{Node creation and removal}
