% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sectionview.fun.R
\docType{methods}
\name{sectionview.function}
\alias{sectionview.function}
\title{Plot section views of a function}
\usage{
\method{sectionview}{`function`}(
  model,
  vectorized = FALSE,
  dim = ifelse(is.null(center), 1, length(center)),
  center = NULL,
  axis = NULL,
  npoints = 100,
  col_surf = "blue",
  mfrow = NULL,
  Xname = NULL,
  yname = NULL,
  Xscale = 1,
  yscale = 1,
  xlim = c(0, 1),
  ylim = NULL,
  title = NULL,
  add = FALSE,
  ...
)
}
\arguments{
\item{model}{an object of class \code{"function"}.}

\item{vectorized}{is model vectorized? (defaults to FALSE)}

\item{dim}{the dimension of fun arguments.}

\item{center}{optional coordinates (as a list or data frame) of the center of the section  view if the model's dimension is > 1.}

\item{axis}{optional matrix of 1-axis combinations to plot, one by row. The value \code{NULL} leads to all possible combinations i.e. \code{1:D}.}

\item{npoints}{an optional number of points to discretize plot of response surface and uncertainties.}

\item{col_surf}{color for the section.}

\item{mfrow}{an optional list to force \code{par(mfrow = ...)} call. The default value  \code{NULL} is automatically set for compact view.}

\item{Xname}{an optional list of string to overload names for X.}

\item{yname}{an optional string to overload name for y.}

\item{Xscale}{an optional factor to scale X.}

\item{yscale}{an optional factor to scale y.}

\item{xlim}{a list to give x range for all plots.}

\item{ylim}{an optional list to force y range for all plots.}

\item{title}{an optional overload of main title.}

\item{add}{to print graphics on an existing window.}

\item{...}{further arguments passed to the first call of \code{plot}.}
}
\description{
Plot one section view per dimension of a function thus providing a better understanding of the model behaviour.
}
\details{
A multiple rows/columns plot is produced.
}
\examples{
## A 2D example - Branin-Hoo function.
sectionview(branin,center=c(.5,.5),
  npoints=8) # for faster display
}
\seealso{
The function \code{\link{sectionview3d}} produces a 3D version.
}
\author{
Yann Richet, IRSN
}
\keyword{models}
