% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBR_fun.R
\name{DBR}
\alias{DBR}
\title{[DBR-lambda] procedure}
\usage{
DBR(raw.pvalues, pCDFlist, alpha = 0.05, lambda = NULL,
  ret.crit.consts = FALSE)
}
\arguments{
\item{raw.pvalues}{vector of the raw observed p-values, as provided by the end user and before matching with their nearest neighbour in the CDFs supports.}

\item{pCDFlist}{a list of the supports of the CDFs of the p-values. Each support is represented by a vector that must be in increasing order.}

\item{alpha}{the target FDR level, a number strictly between 0 and 1.}

\item{lambda}{a number strictly between 0 and 1. If \code{lambda=NULL} (by default), then \code{lambda} is chosen equal to \code{alpha}.}

\item{ret.crit.consts}{a boolean. If \code{TRUE}, critical constants are computed and returned (this is computationally intensive).}
}
\value{
A list whose elements are:
\item{Rejected}{Rejected raw p-values}
\item{Indices}{Indices of rejected hypotheses}
\item{k.hat}{Number of rejections}
\item{Alpha}{Maximum significance level for the transformed p-values for which a rejection occured, that is \eqn{Alpha = alpha * k.hat / m}}
\item{Critical.constants}{Critical constants (if requested)}
\item{Adjusted}{Adjusted p-values }
\item{Lambda}{Value of \code{lambda}.}
}
\description{
Apply the [DBR-lambda] procedure,
with or without computing the critical constants,
to a set of p-values and their discrete support.
}
\details{
[DBR-lambda] is the discrete version of the [Blanchard-Roquain-lambda] procedure (see References),
the authors of the latter suggest to take \code{lambda = alpha} (see their Proposition 17),
which explains the choice of the default value here. 

This version: 2018-11-13.
}
\section{References}{

G. Blanchard and E. Roquain (2009). Adaptive false discovery rate control under independence and dependence. Journal of Machine Learning Research, 10, 2837-2871.
}

\examples{
X1 <- c(4, 2, 2, 14, 6, 9, 4, 0, 1)
X2 <- c(0, 0, 1, 3, 2, 1, 2, 2, 2)
N1 <- rep(148, 9)
N2 <- rep(132, 9)
Y1 <- N1-X1
Y2 <- N2-X2
df <- data.frame(X1,Y1,X2,Y2)
df
#Construction of the p-values and their support
df.formatted <- fisher.pvalues.support(counts = df, input = "noassoc")
raw.pvalues <- df.formatted$raw
pCDFlist <- df.formatted$support

DBR.su.fast <- DBR(raw.pvalues, pCDFlist)
DBR.su.crit <- DBR(raw.pvalues, pCDFlist, ret.crit.consts = TRUE)

}
\seealso{
\code{\link{discrete.BH}}, \code{\link{DiscreteFDR}}
}
