% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/NormalVaR.R
\name{NormalVaR}
\alias{NormalVaR}
\title{VaR for normally distributed P/L}
\usage{
NormalVaR(...)
}
\arguments{
\item{...}{The input arguments contain either return data or else mean and
 standard deviation data along with the remaining arguments. Accordingly, number of input arguments is either 3
 or 4. In case there 3 input arguments, the mean and standard deviation of
 data is computed from return data. See examples for details.

 returns Vector of daily geometric return data

 mu Mean of daily geometric return data

 sigma Standard deviation of daily geometric return data

 cl VaR confidence level

 hp VaR holding period in days}
}
\value{
Matrix of VaR whose dimension depends on dimension of hp and cl. If
cl and hp are both scalars, the matrix is 1 by 1. If cl is a vector and hp is
 a scalar, the matrix is row matrix, if cl is a scalar and hp is a vector,
 the matrix is column matrix and if both cl and hp are vectors, the matrix
 has dimension length of cl * length of hp.
}
\description{
Estimates the VaR of a portfolio assuming that P/L is
normally distributed, for specified confidence level and holding period.
}
\examples{
# Computes VaR given geometric return data
   data <- runif(5, min = 0, max = .2)
   NormalVaR(returns = data, cl = .95, hp = 90)

   # Computes VaR given mean and standard deviation of return data
   NormalVaR(mu = .012, sigma = .03, cl = .95, hp = 90)
}
\author{
Dinesh Acharya
}
\references{
Dowd, K. Measuring Market Risk, Wiley, 2007.
}

