% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelEval.R
\name{visbeta}
\alias{visbeta}
\title{Format scores output for visualization}
\usage{
visbeta(mcmc.output, Y, D, chain = 1, axes = c(1, 2), quant = NULL)
}
\arguments{
\item{mcmc.output}{an mcmc list as produced by clean.mcmc}

\item{Y}{the matrix of data}

\item{D}{the number of latent factors}

\item{chain}{the chain to use (default = 1)}

\item{axes}{the axes to use (default = c(1, 2))}

\item{quant}{a vector of quantiles to retain (default = NULL)}
}
\value{
mean.df are the MCMC estimates for the parmeters

points.df contains all of the estimates of the chain

contour.df contains the exterior points of the convex hull of the cloud of estimates
}
\description{
Format scores output for visualization
}
\examples{
data("toydata")
data("stanfit")
codafit <- coda.obj(stanfit) ## convert to mcmc.list
beta.res <- visbeta(codafit, Y = toydata$Y.simul$Y, D = toydata$wlu$D, chain = 1,
axes = c(1, 2), quant = c(0.05, 0.95))

ggplot2::ggplot() +
  ggplot2::geom_path(data = beta.res$contour.df, ggplot2::aes(x = x, y = y, colour = ind)) +
  ggplot2::geom_point(data = beta.res$mean.df, ggplot2::aes(x = x, y = y, colour = ind))

}
\author{
Gabrielle Weinrott
}

