% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimRed.R
\name{weighted.Deville}
\alias{weighted.Deville}
\title{Perform a weighted PCA using Deville's method
on a data matrix X that we project
onto a histogram basis and weighted}
\usage{
weighted.Deville(X, t, t.range, breaks, Qp = NULL)
}
\arguments{
\item{X}{a data matrix}

\item{t}{a matrix of observation times corresponding to X}

\item{t.range}{the range of observation times in vector form (ex. t.range = c(a, b))}

\item{breaks}{integer number of histogram windows}

\item{Qp}{a matrix of weights, if Qp = NULL the function specifies a diagonal weight matrix}
}
\value{
X.histo the matrix projected onto the histogram basis

U.histo a matrix of eigenvectors in the histogram basis

Cp a matrix of principal components

lambda a vector of eigenvalues

perc.lambda a vector of the percentage of total inertia explained by each principal component
}
\description{
Perform a weighted PCA using Deville's method
on a data matrix X that we project
onto a histogram basis and weighted
}
\examples{
res <- drbats.simul(N = 5, P = 100, t.range = c(5, 100), breaks = 8)
res.weighted <- weighted.Deville(res$X, res$t.simul, t.range = c(5, 100), breaks = 8, Qp = NULL)
res.weighted

}
\author{
Gabrielle Weinrott
}
