% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missingPattern.R
\name{misspattern}
\alias{misspattern}
\title{Missing pattern analysis for missing data}
\usage{
misspattern(data, mfeature, drop = 0.99, print = FALSE)
}
\arguments{
\item{data}{[data.frame | Required] data set with missing values}

\item{mfeature}{[character | Required] only missing variable name}

\item{drop}{[numeric | optional] drop variable percentage. Example, if drop = 0.9, function will automatically drop 90per missing columns from the data set}

\item{print}{[character | optional] defualt print is FALSE}
}
\value{
final variable list, summary of missing data analysis
}
\description{
This function is used to summarise the missing variable, missing pattern identification and classifying the columns based on the pattern of missing values.
}
\examples{
## Sample iris data
mdata <- iris
mobject <- misspattern(mdata, mfeature = c("Sepal.Length", "Petal.Length"), drop = 0.99, print = F)
}
