% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summariseDrugUse.R
\name{drugUseColumns}
\alias{drugUseColumns}
\title{Obtain automatically the drug use columns}
\usage{
drugUseColumns(cohort)
}
\arguments{
\item{cohort}{A cohort}
}
\value{
Name of the drug use columns
}
\description{
Obtain automatically the drug use columns
}
\examples{
\donttest{
library(DrugUtilisation)
library(CodelistGenerator)

cdm <- mockDrugUtilisation()
acetaminophen <- getDrugIngredientCodes(cdm, "acetaminophen")
cdm <- generateDrugUtilisationCohortSet(
  cdm, "dus", acetaminophen
)
cdm$dus <- cdm$dus \%>\%
  addDrugUse(cdm, 1125315, acetaminophen)
drugUseColumns(cdm$dus)
}

}
