% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addDrugUtilisation.R
\name{addDrugUtilisation}
\alias{addDrugUtilisation}
\title{Add new columns with drug use related information}
\usage{
addDrugUtilisation(
  cohort,
  gapEra,
  conceptSet = NULL,
  ingredientConceptId = NULL,
  indexDate = "cohort_start_date",
  censorDate = "cohort_end_date",
  restrictIncident = TRUE,
  numberExposures = TRUE,
  numberEras = TRUE,
  exposedTime = TRUE,
  timeToExposure = TRUE,
  initialQuantity = TRUE,
  cumulativeQuantity = TRUE,
  initialDailyDose = TRUE,
  cumulativeDose = TRUE,
  nameStyle = "{value}_{concept_name}_{ingredient}",
  name = NULL
)
}
\arguments{
\item{cohort}{Cohort in the cdm}

\item{gapEra}{Number of days between two continuous exposures to be
considered in the same era.}

\item{conceptSet}{List of concepts to be included. If NULL all the
descendants of ingredient concept id will be used.}

\item{ingredientConceptId}{Ingredient OMOP concept that we are interested for
the study. It is a compulsory input, no default value is provided.}

\item{indexDate}{Name of a column that indicates the date to start the
analysis.}

\item{censorDate}{Name of a column that indicates the date to stop the
analysis, if NULL end of individuals observation is used.}

\item{restrictIncident}{Whether to include only incident prescriptions in the
analysis. If FALSE all prescriptions that overlap with the study period will
be included.}

\item{numberExposures}{Whether to add a column with the number of exposures.}

\item{numberEras}{Whether to add a column with the number of eras.}

\item{exposedTime}{Whether to add a column with the number of exposed days.}

\item{timeToExposure}{Whether to add a column with the number of days between
indexDate and start of the first exposure.}

\item{initialQuantity}{Whether to add a column with the initial quantity.}

\item{cumulativeQuantity}{Whether to add a column with the cumulative
quantity of the identified prescription.}

\item{initialDailyDose}{Whether to add a column with the initial daily dose.}

\item{cumulativeDose}{Whether to add a column with the cumulative dose.}

\item{nameStyle}{Character string to specify the nameStyle of the new columns.}

\item{name}{Name of the new computed cohort table, if NULL a temporary tables
is created.}
}
\value{
The same cohort with the added columns.
}
\description{
Add new columns with drug use related information
}
\examples{
\donttest{
library(DrugUtilisation)

cdm <- mockDrugUtilisation()
codelist <- CodelistGenerator::getDrugIngredientCodes(
  cdm,
  name = "acetaminophen"
)

cdm <- generateDrugUtilisationCohortSet(cdm, "dus_cohort", codelist)
cdm[["dus_cohort"]] |>
  addDrugUtilisation(ingredientConceptId = 1125315, gapEra = 30)
}

}
