% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plotIndication}
\alias{plotIndication}
\title{Generate a plot visualisation (ggplot2) from the output of
summariseIndication}
\usage{
plotIndication(
  result,
  x = "window",
  facet = c("cdm_name", "cohort_name", "strata"),
  color = c("indication"),
  splitStrata = TRUE
)
}
\arguments{
\item{result}{A summarised_result object.}

\item{x}{Variables to be used in the x axis.}

\item{facet}{Variables to be used to facet the plot.}

\item{color}{Variables to be used to color the plot.}

\item{splitStrata}{Whether to split strata.}
}
\value{
A ggplot2 object
}
\description{
Generate a plot visualisation (ggplot2) from the output of
summariseIndication
}
\examples{
\donttest{
library(DrugUtilisation)
library(CDMConnector)
library(dplyr)

cdm <- mockDrugUtilisation()

indications <- list("headache" = 378253, "asthma" = 317009)
cdm <- generateConceptCohortSet(cdm, indications, "indication_cohorts")

cdm <- generateIngredientCohortSet(
  cdm = cdm, name = "drug_cohort", ingredient = "acetaminophen"
)

result <- cdm$drug_cohort |>
  summariseIndication(
    indicationCohortName = "indication_cohorts",
    unknownIndicationTable = "condition_occurrence",
    indicationWindow = list(c(-Inf, 0), c(-365, 0))
  )

plotIndication(result)
}

}
