% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plotDrugUtilisation}
\alias{plotDrugUtilisation}
\title{Plot the results of \code{summariseDrugUtilisation}}
\usage{
plotDrugUtilisation(
  result,
  variable = "number exposures",
  plotType = "barplot",
  facet = strataColumns(result),
  colour = "cohort_name"
)
}
\arguments{
\item{result}{A summarised_result object.}

\item{variable}{Variable to plot. See \code{unique(result$variable_name)} for
options.}

\item{plotType}{Must be a choice between: 'scatterplot', 'barplot',
'densityplot', and 'boxplot'.}

\item{facet}{Columns to facet by. See options with
\code{availablePlotColumns(result)}. Formula is also allowed to specify rows and
columns.}

\item{colour}{Columns to color by. See options with
\code{availablePlotColumns(result)}.}
}
\value{
A ggplot2 object.
}
\description{
Plot the results of \code{summariseDrugUtilisation}
}
\examples{
\donttest{
cdm <- mockDrugUtilisation(numberIndividuals = 100)
codes <- list(aceta = c(1125315, 1125360, 2905077, 43135274))
cdm <- generateDrugUtilisationCohortSet(
  cdm = cdm,
  name = "cohort",
  conceptSet = codes
)

result <- cdm$cohort |>
  PatientProfiles::addSex() |>
  summariseDrugUtilisation(
    strata = "sex",
    ingredientConceptId = 1125315,
    estimates = c("min", "q25", "median", "q75", "max", "density")
  )

result |>
  dplyr::filter(estimate_name == "median") |>
  plotDrugUtilisation(
    variable = "days prescribed",
    plotType = "barplot"
  )

result |>
  plotDrugUtilisation(
    variable = "days exposed",
    facet = cohort_name ~ cdm_name,
    colour = "sex",
    plotType = "boxplot"
  )

result |>
  plotDrugUtilisation(
    variable = "cumulative dose milligram",
    plotType = "densityplot",
    facet = "cohort_name",
    colour = "sex"
  )

mockDisconnect(cdm)
}

}
