% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summariseIntersect.R
\name{summariseTreatment}
\alias{summariseTreatment}
\title{This function is used to summarise treatments received}
\usage{
summariseTreatment(
  cohort,
  window,
  treatmentCohortName,
  cohortId = NULL,
  treatmentCohortId = NULL,
  strata = list(),
  indexDate = "cohort_start_date",
  censorDate = NULL,
  mutuallyExclusive = FALSE
)
}
\arguments{
\item{cohort}{A cohort_table object.}

\item{window}{Time window over which to summarise the treatments.}

\item{treatmentCohortName}{Name of a cohort in the cdm that contains the
treatments of interest.}

\item{cohortId}{A cohort definition id to restrict by. If NULL, all cohorts
will be included.}

\item{treatmentCohortId}{Cohort definition id of interest from
treatmentCohortName.}

\item{strata}{A list of variables to stratify results. These variables
must have been added as additional columns in the cohort table.}

\item{indexDate}{Name of a column that indicates the date to start the
analysis.}

\item{censorDate}{Name of a column that indicates the date to stop the
analysis, if NULL end of individuals observation is used.}

\item{mutuallyExclusive}{Whether to include mutually exclusive treatments or
not.}
}
\value{
A summary of treatments stratified by cohort_name and strata_name
}
\description{
This function is used to summarise treatments received
}
\examples{
\donttest{
library(DrugUtilisation)

cdm <- mockDrugUtilisation()
cdm$cohort1 |>
  summariseTreatment(
    treatmentCohortName = "cohort2",
    window = list(c(0, 30), c(31, 365))
  )
}

}
