% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtDescriptives.R
\name{rtDescriptives}
\alias{rtDescriptives}
\title{Descriptives of reaction time data}
\usage{
rtDescriptives(data)
}
\arguments{
\item{data}{A reaction time dataset. Must be a dataframe with $rt, $condition
and $response.}
}
\value{
An object of class 'D*M', containing raw counts and proportions for
condition response pairs, conditions, and responses.
}
\description{
Descriptives of reaction time data
}
\details{
This function and \code{\link{rtHist}} are helper functions to inspect raw data.
}
\examples{
tt = seq(0, 5, .01)
dat = simData(n = 3e5, pars = rep(.5, 5), tt = tt, pdfND = dbeta(tt, 10, 30))
x = rtDescriptives(dat)
x
print(x, what = 'cr')
print(x, what = 'c')
print(x, what = 'r')
print(x, digits = 20)
}
