% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DynComm.R
\docType{methods}
\name{communityMapping}
\alias{communityMapping}
\alias{DynComm.communityMapping}
\title{communityMapping(differential, file)}
\usage{
DynComm.communityMapping(dyncomm,differential, file)
}
\arguments{
\item{dyncomm}{A DynComm object, if not using the inline version of the 
function call}

\item{differential}{If TRUE, only values that have changed in the latest run 
will be returned}

\item{file}{If given, outputs the community mapping to the given file instead 
of the console}
}
\value{
a matrix with either the community mapping or a boolean value
}
\description{
Get the community mapping for all communities from the selected post processing
algorithm or the main algorithm, after the last iteration.
}
\details{
If file is not given, returns a two column matrix with vertices in 
the first column and the communities in the second.

If file is given, returns a single row, single column matrix with TRUE or 
FALSE, depending whether if writing to file succeeded or failed, respectively.

When writing to file, if the Community-Vertex program parameter is TRUE, each 
line of the file will have the community first, followed by a list of vertices
that belong to the community. If that parameter is FALSE, each line will have
a single vertex followed by its community. All values are separated by a white
character.
}
\examples{
library(DynComm)

Parameters<-matrix(c("e","0.1","w", "FALSE"),ncol=2, byrow=TRUE)
dc<-DynComm(ALGORITHM$LOUVAIN,CRITERION$MODULARITY,Parameters)
dc$addRemoveEdges(
 matrix(
   c(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,12,13,1,1,1,2,2,2,18,12,19,20,2,3,11,12,4,9,5,9,22)
      ,ncol=2)
)

dc$communities()
dc$communityMapping()

}
\seealso{
\code{\link{DynComm}} , \code{\link{postProcess}}
}
\author{
poltergeist0
}
