% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.DynForest}
\alias{summary.DynForest}
\title{Display the summary of DynForest}
\usage{
\method{summary}{DynForest}(object, ...)
}
\arguments{
\item{object}{\code{DynForest} or \code{DynForest_OOB} object}

\item{...}{Optional parameters to be passed to the low level function}
}
\value{
Return some information about the random forest
}
\description{
Display the summary of DynForest
}
\examples{
\donttest{
data(pbc2)

# Get Gaussian distribution for longitudinal predictors
pbc2$serBilir <- log(pbc2$serBilir)
pbc2$SGOT <- log(pbc2$SGOT)
pbc2$albumin <- log(pbc2$albumin)
pbc2$alkaline <- log(pbc2$alkaline)

# Sample 100 subjects
set.seed(1234)
id <- unique(pbc2$id)
id_sample <- sample(id, 100)
id_row <- which(pbc2$id\%in\%id_sample)

pbc2_train <- pbc2[id_row,]

timeData_train <- pbc2_train[,c("id","time",
                                "serBilir","SGOT",
                                "albumin","alkaline")]

# Create object with longitudinal association for each predictor
timeVarModel <- list(serBilir = list(fixed = serBilir ~ time,
                                     random = ~ time),
                     SGOT = list(fixed = SGOT ~ time + I(time^2),
                                 random = ~ time + I(time^2)),
                     albumin = list(fixed = albumin ~ time,
                                    random = ~ time),
                     alkaline = list(fixed = alkaline ~ time,
                                     random = ~ time))

# Build fixed data
fixedData_train <- unique(pbc2_train[,c("id","age","drug","sex")])

# Build outcome data
Y <- list(type = "surv",
          Y = unique(pbc2_train[,c("id","years","event")]))

# Run DynForest function
res_dyn <- DynForest(timeData = timeData_train, fixedData = fixedData_train,
                     timeVar = "time", idVar = "id",
                     timeVarModel = timeVarModel, Y = Y,
                     ntree = 50, nodesize = 5, minsplit = 5,
                     cause = 2, ncores = 2, seed = 1234)

# Compute OOB error
res_dyn_OOB <- compute_OOBerror(DynForest_obj = res_dyn, ncores = 2)

# DynForest summary
summary(object = res_dyn_OOB)
}
}
\author{
Anthony Devaux (\email{anthony.devaux@u-bordeaux.fr})
}
