% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/E4.part2.ExtractButtonPresses.R
\name{E4_EDA_Process.part2.ExtractButtonPresses}
\alias{E4_EDA_Process.part2.ExtractButtonPresses}
\title{EDA Processing Part 2: Extract button presses}
\usage{
E4_EDA_Process.part2.ExtractButtonPresses(participant_list, ziplocation,
  rdslocation.buttonpress, summarylocation, cutoff.ends = 0,
  cutoff.overlap = 0)
}
\arguments{
\item{participant_list}{list of participant numbers NOTE: This should match the names of the folders (e.g., participant 1001's data should be in a folder called "1001")}

\item{ziplocation}{folder location where the participant-level subfolders are (make sure that it ends in /)}

\item{rdslocation.buttonpress}{folder location where you want the RDS output to go (make sure that it ends in /). The file will be named "button_presses.RDS"}

\item{summarylocation}{location of folder where summaries from part 1 were saved (make sure that it ends in /)}

\item{cutoff.ends}{how close (in minutes) to the ends of a file do you want to cut off button presses (because they could be accidental e.g., when turning the band off). Default is 0, which will not remove button presses at all.}

\item{cutoff.overlap}{if you want to remove button presses within X number of minutes, enter that value here. Default is 0, which will not remove button presses at all.}
}
\description{
This function allows you extract button presses and remove presses that are within a certain number of minutes before the end of a session or that are too close to another button press. If the participant has not pressed the button at all, it will give you a warning and continue with the other participants.
}
\examples{
E4_EDA_Process.part2.ExtractButtonPresses(participant_list=c(1001:1002),
                                          ziplocation=paste(system.file(package="E4tools"),
                                          "/extdata/E4_demo_data/",sep=""),
                                          rdslocation.buttonpress=paste(tempdir(),
                                          "/extdata/output/presses/",sep=""),
                                          summarylocation=paste(system.file(package="E4tools"),
                                          "/extdata/output/summaries/",sep=""),
                                          cutoff.ends=2, cutoff.overlap=20)




}
\keyword{EDA}
