% Generated by roxygen2 (4.0.2): do not edit by hand
\name{CalculateLikelihoodRatio}
\alias{CalculateLikelihoodRatio}
\title{Calculates the ratio of two likelihoods in a structure move.}
\usage{
CalculateLikelihoodRatio(gamma0, y, Pxlm, Pxl, v0, delta2, dir)
}
\arguments{
\item{gamma0}{Hyperparameter.}

\item{y}{Target data.}

\item{Pxlm}{Projection matrix with modified edge.}

\item{Pxl}{Original projection matrix.}

\item{v0}{Hyperparameter.}

\item{delta2}{Delta squared parameter (signal-to-noise).}

\item{dir}{Direction of the change: 1 = Added an edge. 2 = Removed an edge.
0 = No change.}
}
\value{
Returns the likelihood ratio.
}
\description{
This function calculates the ratio of the liklihoods in a network structure
move. The returned value is the ratio for the modification of one edge in
one segment.
}
\author{
Frank Dondelinger
}
\references{
For more information about the hyperparameters and the
functional form of the likelihood, see:

Dondelinger et al. (2012), "Non-homogeneous dynamic Bayesian networks with
Bayesian regularization for inferring gene regulatory networks with
gradually time-varying structure", Machine Learning.
}
\seealso{
\code{\link{CalculatePriorRatio}}
}

