% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_data_descendants.R
\name{list_data_descendants}
\alias{list_data_descendants}
\title{List data descendants}
\usage{
list_data_descendants(packageId, as = "data.frame", env = "production")
}
\arguments{
\item{packageId}{(character) Data package identifier}

\item{as}{(character) Format of the returned object. Can be: "data.frame" 
or "xml".}

\item{env}{(character) Repository environment. Can be: "production",
"staging", or "development".}
}
\value{
(data.frame or xml_document) Descendants of \code{packageId}
}
\description{
Data descendants are data packages that are known to be
derived, in whole or in part, from the specified source data package.
}
\examples{
\dontrun{

# List descendants
dataDescendants <- list_data_descendants("knb-lter-bnz.501.17")
}
}
\seealso{
Other Listing: 
\code{\link{list_data_entities}()},
\code{\link{list_data_package_identifiers}()},
\code{\link{list_data_package_revisions}()},
\code{\link{list_data_package_scopes}()},
\code{\link{list_data_sources}()},
\code{\link{list_deleted_data_packages}()},
\code{\link{list_recent_changes}()},
\code{\link{list_recent_uploads}()},
\code{\link{list_service_methods}()},
\code{\link{list_user_data_packages}()}
}
\concept{Listing}
