% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EEAaq_idw_map.R
\name{EEAaq_idw_map}
\alias{EEAaq_idw_map}
\title{Build a spatial interpolation map based on the Inverse Distance Weighting technique.}
\usage{
EEAaq_idw_map(
  data = NULL,
  pollutant = NULL,
  aggr_fun,
  bounds_level = NULL,
  distinct = FALSE,
  gradient = TRUE,
  idp = 2,
  nmax = NULL,
  maxdist = NULL,
  dynamic = FALSE,
  fill_NUTS_level = NULL,
  tile = "Esri.WorldGrayCanvas",
  save = NULL,
  filepath = NULL,
  width = 1280,
  height = 720,
  res = 144,
  delay = 1,
  verbose = TRUE
)
}
\arguments{
\item{data}{an object of class \code{EEAaq_taggr_df} or \code{EEAaq_taggr_df_sfc}, which is the
output of the \code{\link{EEAaq_time_aggregate}} function.}

\item{pollutant}{vector containing the pollutant for which to build the map. It must be one of the pollutants
contained in \code{data}.}

\item{aggr_fun}{charachter containing the aggregation function to use for computing the interpolation. It must
be one of the statistics contained in \code{data}.}

\item{bounds_level}{character containing the NUTS level or LAU for which draw internal boundaries.
Admissible values are 'NUTS0', 'NUTS1', 'NUTS2', 'NUTS3', 'LAU'.}

\item{distinct}{logic value (T or F). If \code{TRUE}, each map generated is printed and saved in distinct pages
(for instance if \code{data} has a monthly frequency in a yearly time window, 12 distinct plots are generated).
If \code{FALSE} (the default), the maps are printed in a single page.}

\item{gradient}{logic value (T or F). If \code{TRUE} (the default) the maps generated are colored with a
continuous color scale. If \code{FALSE}, the color scale is discrete.}

\item{idp}{numeric value that specify the inverse distance weighting power. For further information see
\code{\link[gstat]{idw}}.}

\item{nmax}{numeric value; specify the number of nearest observations that should be
used for the inverse distance weighting computing, where nearest is defined in terms of the
space of the spatial locations. By default, all observations are used. For further information see
\code{\link[gstat]{idw}}}

\item{maxdist}{numeric value; only observations within a distance of \code{maxdist} from the prediction location
are used for the idw computation. By default, all observations are used.
If combined with \code{nmax}, both criteria apply.}

\item{dynamic}{logic value (T or F). If \code{TRUE} the function creates a Leaflet map widget using
\bold{htmlwidgets} (for further information see \code{\link[leaflet]{leaflet}}). If \code{FALSE} (the default)
the maps generated are static.}

\item{fill_NUTS_level}{character containing the NUTS level or LAU for which to aggregate the idw computing,
in order to obtain a uniform coloring inside each area at the specified level.
(For instance if \code{fill_NUTS_level = "LAU"}, each municipality is filled by the mean value of the pollutant
concentration, computed by the idw, of each pixel inside the respective municipality). Allowed values are
'NUTS0', 'NUTS1', 'NUTS2', 'NUTS3', 'LAU'.}

\item{tile}{character representing the name of the provider tile. To see the full list of the providers, run
\code{\link[leaflet]{providers}}. For further information see \code{\link[leaflet]{addProviderTiles}}.}

\item{save}{character representing in which extension to save the map. Allowed values are 'jpeg', 'png', 'pdf'
(if \code{dynamic = FALSE}), 'gif' (if \code{dynamic = FALSE & distinct = TRUE}), 'html' (if \code{dynamic = TRUE}).}

\item{filepath}{a character string giving the file path.}

\item{width, height}{the width and the height of the plot, expressed in pixels (by default \code{width = 1280, height = 720}).
This parameters are available only for \code{save} 'jpeg', 'png' and 'gif'.
For further information see \code{\link{png}} or \code{\link{jpeg}}.}

\item{res}{the nominal resolution in ppi which will be recorded in the bitmap file, if a positive integer
(by default \code{res = 144}). This parameter is available only for \code{save} 'jpeg', 'png'.
For further information see \code{\link{png}} or \code{\link{jpeg}}.}

\item{delay}{numeric value specifying the time to show each image in seconds, when \code{save = "gif"}.}

\item{verbose}{logic value (T or F). If \code{TRUE} (the default) information about the function progress are printed.
If \code{FALSE} no message is printed.}
}
\value{
cosa restituisce la funzione
}
\description{
\code{EEAaq_idw_map} recieves as input a \code{EEAaq_taggr_df} or a \code{EEAaq_taggr_df_sfc} class object and produces a
spatial interpolation map. Depending on the time frequency of the aggregation, multiple maps are generated, one for
each timestamp.
It may be exported as pdf, jpeg, png, gif and html.
}
\details{
\code{EEAaq_idw_map} create a spatial interpolation map, based on the Inverse Distance Weighting method (Shepard 1968).
This method starts from the available georeferenced data and estimates the value of the variable in the points
where it's unknown as a weighted average of the known values, where weights are given by an inverse function of the
distance of every point from the fixed stations.
The greater the distance of a point from a station, the smaller the weight assigned to the values of the respective
station for the computing of that unknown point.
Given the sampling plan \eqn{s_{i}} for \eqn{i=1,...,n}, which represent the location of the air quality stations,
the pollutant concentration value \eqn{Y(s_i)=Y_i} represents the value of the pollutant concentration detected
by the site \eqn{s_i} and \eqn{u} is the point for which the value of the concentration in unknown.
\deqn{\hat{Y}(u) = \sum_{i=1}^{n} Y_i \omega_i(u), } where
\deqn{\omega_i(u) = \frac{g(d(s_i,u))}{\sum_{i=1}^{n}g(d(s_i,u))} }
represent the weights assigned to each location \eqn{s_i} and \eqn{d(s_i,u)} is the distance between \eqn{u}
and \eqn{s_i}.
}
\examples{
\dontrun{
# Download daily NO2 data in 2023 for Milan city (LAU)
data <- EEAaq_get_data(zone_name = "15146", NUTS_level = "LAU",LAU_ISO = "IT",
pollutants = "NO2", from = "2023-01-01", to = "2023-12-31",  verbose = TRUE)
# Monthly aggregation
t_aggr <- EEAaq_time_aggregate(data = data, frequency = "monthly",
aggr_fun = c("mean", "min", "max"))

# One map created
EEAaq_idw_map(data = t_aggr, pollutant = "NO2", aggr_fun = "mean",
distinct = TRUE, gradient = FALSE, dynamic = TRUE, fill_NUTS_level = "LAU")


# Let's try to change the parameters fill_NUTS_level and dynamic:
# now we are going to use a dataset containing PM10 concentrations
# in Milan province (NUTS 3), during 2023
data <- EEAaq_get_data(zone_name = "Centro (IT)", NUTS_level = "NUTS1",
pollutant = "PM10", from = "2023-01-01", to = "2023-12-31")
# Yearly aggregation
t_aggr <- EEAaq_time_aggregate(data = data, frequency = "yearly", aggr_fun = "mean")

# Let us generate one dynamic map, containing the municipalities inside the Milan province
# filled with the mean concentration value for 2023, computed via IDW:
EEAaq_idw_map(data = t_aggr, pollutant = "PM10", aggr_fun = "mean",
distinct = TRUE, gradient = FALSE, dynamic = TRUE, fill_NUTS_level = "NUTS3")
}

}
