% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.EFAscreet}
\alias{plot.EFAscreet}
\title{Plots the Scree Plot}
\usage{
\method{plot}{EFAscreet}(x, ...)
}
\arguments{
\item{x}{An object of class \code{EFAscreet}, which contains the eigenvalues from the factor analysis.}

\item{...}{Additional arguments to be passed to the \code{plot} function (not used).}
}
\value{
A scree plot displaying the eigenvalues against the number of factors.
}
\description{
Plots the Scree Plot from an object of class \code{EFAscreet}. The scree plot visualizes the eigenvalues
of the correlation matrix in descending order and helps in identifying the optimal number of factors
by showing where the eigenvalues start to plateau.
}
\details{
The scree plot is a graphical tool used in exploratory factor analysis. It shows the eigenvalues
corresponding to the factors. The number of factors is typically determined by finding the point
where the plot levels off ("elbow" point).
}
\examples{
library(EFAfactors)
set.seed(123)

##Take the data.bfi dataset as an example.
data(data.bfi)

response <- as.matrix(data.bfi[, 1:25]) ## loading data
response <- na.omit(response) ## Remove samples with NA/missing values

## Transform the scores of reverse-scored items to normal scoring
response[, c(1, 9, 10, 11, 12, 22, 25)] <- 6 - response[, c(1, 9, 10, 11, 12, 22, 25)] + 1


## Run EFAscreet function with default parameters.
\donttest{
 EFAscreet.obj <- EFAscreet(response)

 plot(EFAscreet.obj)

}

}
