% Generated by roxygen2 (4.0.2): do not edit by hand
\name{df.to.mat}
\alias{df.to.mat}
\title{Change xyz data-frame into a Z image}
\usage{
df.to.mat(df)
}
\arguments{
\item{df}{data frame with fields \code{x}, \code{y} and \code{z}}
}
\value{
matrix image
}
\description{
Given a data frame with fields \code{x, y} and \code{z}, \code{df.to.mat} uses the \code{x} and
\code{y} coordinates to rearrange \code{z} into a rectangular matrix image \code{Z}.
}
\details{
This function requires that \emph{all} pixels in the image are defined, that is \code{df$x} and \code{df$y} must be the
column outputs of the function \code{expand.grid(x0,y0)} where \code{x0, y0} are axes values. Note that \code{x0} and
\code{y0} do not need to be regularly spaced.
}
\examples{
df <- data.frame(expand.grid(1:10,1:10))
names(df) <- c("x","y")
df$z <- rnorm(nrow(df))
Z <- df.to.mat(df)
}
\keyword{image}
\keyword{reshape,}

