% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/community.homogenize.R
\name{community.homogenize}
\alias{community.homogenize}
\title{Homogenize Community Memberships}
\usage{
community.homogenize(target.membership, convert.membership)
}
\arguments{
\item{target.membership}{Vector, matrix, or data frame.
The target memberships that all other memberships input into
\code{convert.membership} should be homogenize \strong{toward}}

\item{convert.membership}{Vector, matrix, or data frame.
Either a vector of memberships the same length as
\code{target.membership} or a matrix or data frame of many
membership solutions with either across rows or down columns the same
length as \code{target.membership} (this function will automatically
determine this orientation for you with precedence given solutions
\emph{across rows})}
}
\value{
Returns a vector or matrix the length or size of
\code{convert.membership} with memberships homogenized toward
\code{target.membership}
}
\description{
Memberships from community detection algorithms do not always
align numerically. This function seeks to homogenize 
community memberships between a target membership (the 
membership to homogenize toward) and one or more other 
memberships. This function is the core of the 
\code{\link[EGAnet]{dimensionStability}} and 
\code{\link[EGAnet]{itemStability}} functions
}
\examples{
# Get network
network <- network.estimation(wmt2[,7:24])

# Apply Walktrap
network_walktrap <- community.detection(
  network, algorithm = "walktrap"
)

# Apply Louvain
network_louvain <- community.detection(
  network, algorithm = "louvain"
)

# Homogenize toward Walktrap
community.homogenize(network_walktrap, network_louvain)

}
\references{
\strong{Original implementation of bootEGA} \cr
Christensen, A. P., & Golino, H. (2021).
Estimating the stability of the number of factors via Bootstrap Exploratory Graph Analysis: A tutorial.
\emph{Psych}, \emph{3}(3), 479-500.
}
\author{
Hudson Golino <hfg9s at virginia.edu> and Alexander P. Christensen <alexpaulchristensen@gmail.com>
}
