% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cosine.R
\name{cosine}
\alias{cosine}
\title{Cosine similarity}
\usage{
cosine(x, y = NULL, ...)
}
\arguments{
\item{x}{Numeric vector, matrix, or data frame.
If \code{nrow(x) > 1}, then \code{x} will be treated as a matrix
to compute an \emph{n} by \emph{n} similarity matrix (\code{y} will not be used!)}

\item{y}{Numeric vector, matrix, or data frame.
Only used if \code{x} is a single variable.
Used to compute similarity between one variable and \emph{n} other variables.
Defaults to \code{NULL}}

\item{...}{Not actually used but makes it easier for general functionality
in the package}
}
\description{
Computes cosine similarity
}
\details{
On missing values: \code{0} will be used to replace missing values.
When using (matrix) multiplication, the \code{0} value cancels out the
product rendering the missing value as "not counting" in the sums
}
\examples{
# Load data
wmt <- wmt2[,7:24]

# Obtain cosines
wmt_cosine <- cosine(wmt)

}
\author{
Alexander P. Christensen <alexpaulchristensen@gmail.com>
}
