% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_funcs.R
\name{check.emc}
\alias{check.emc}
\alias{check}
\title{Convergence checks for an emc object}
\usage{
\method{check}{emc}(
  emc,
  selection = c("mu", "sigma2", "alpha"),
  digits = 3,
  plot_worst = TRUE,
  ...
)

check(emc, ...)
}
\arguments{
\item{emc}{An emc object}

\item{selection}{A Character vector. Indicates which parameter types to check (e.g., \code{alpha}, \code{mu}, \code{sigma2}, \code{correlation}).}

\item{digits}{Integer. How many digits to round the ESS and Rhat to in the plots}

\item{plot_worst}{Boolean. If \code{TRUE} also plots the chain plots for the worst parameter}

\item{...}{Optional arguments that can be passed to \code{get_pars} or \code{plot.default} (see \code{par()})}
}
\value{
a list with the statistics for the worst converged parameter per selection
}
\description{
Runs a series of convergence checks, prints statistics to the console, and
makes traceplots of the worst converged parameter per selection.
}
\details{
Note that the \code{Rhat} is calculated by doubling the number of chains by
first splitting chains into first and second half, so it also a test of
stationarity.

Efficiency of sampling is indicated by the effective
sample size (ESS) (from the \code{coda} R package).
Full range of possible samples manipulations described in \code{get_pars}.
}
\examples{
check(samples_LNR)
}
