% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/plots.R
\name{plot_perms}
\alias{plot_perms}
\title{Plot histogram of EMD scores calculated via random permutation.}
\usage{
plot_perms(emdobj)
}
\arguments{
\item{emdobj}{An \code{\link{EMDomics}} object, typically returned via a call
to \code{\link{calculate_emd}}.}
}
\value{
A \code{\link[ggplot2]{ggplot}} object is returned. If the value is
not assigned, a plot will be drawn.
}
\description{
The permuted EMD scores stored in \code{emdobj$emd.perm} are
plotted as a histogram.
}
\examples{
# 100 genes, 100 samples
dat <- matrix(rnorm(10000), nrow=100, ncol=100)
rownames(dat) <- paste("gene", 1:100, sep="")
colnames(dat) <- paste("sample", 1:100, sep="")

# "group A" = first 50, "group B" = second 50
groupA <- colnames(dat)[1:50]
groupB <- colnames(dat)[51:100]

results <- calculate_emd(dat, groupA, groupB, nperm=10)
plot_perms(results)
}
\seealso{
\code{\link{calculate_emd}} \code{\link[ggplot2]{ggplot}}
}

