% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/click.limits.R
\name{click.limits}
\alias{click.limits}
\title{Define mode limits by mouse clicks.}
\usage{
click.limits(data, n, classunits)
}
\arguments{
\item{data}{\code{List} object, output of \code{\link{test.robustness}}.}

\item{n}{\code{Numeric} scalar, number of target end-members.}

\item{classunits}{\code{Numeric} vector, optional class units (e.g. 
micrometers or phi-units).}
}
\value{
\code{Numeric} matrix, limit classes. The first row contains lower
limits, the second row upper limits for each end-member.
}
\description{
This function allows defining limits for robust end-members by mouse clicks
on a combined plot output, showing a histogram and all end-members together.
Clicks must be placed in the order lower limit, upper limit - for each
end-member successively.
}
\examples{

## load example data set
data(example_X)

## Test robustness
q <- 4:7
l <- seq(from = 0, to = 0.1, by = 0.02)
TR <- test.robustness(X = X, q = q, l = l)

## define 2 limits by mouse clicks (uncomment to use).
# limits <- click.limits(data = TR, n = 2)
# limits  

}
\seealso{
\code{\link{test.robustness}}, \code{\link{robust.EM}}
}
\author{
Michael Dietze, Elisabeth Dietze
}
\keyword{EMMA}
