% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ApproxF.R
\name{Approx.F}
\alias{Approx.F}
\title{Calculate ANOVA with approximate F value}
\usage{
Approx.F(SS.table,approx.id,...)
}
\arguments{
\item{SS.table}{result from EMS.anova}

\item{approx.id}{id's to calculate approximate F value for the test. Use rownames of SS.table}

\item{...}{arguments to be passed to methods}
}
\description{
Calculate ANOVA with approximate F value
}
\examples{
G<-rep(rep(1:3,each=2),6)
O<-rep(rep(c("A","B","C"),each=6),2)
D<-rep(1:2,each=18)
Y<-c(0.38,0.4,0.63,0.59,0.76,0.78,0.39,0.41,0.72,0.7,
     0.95,0.96,0.45,0.4,0.78,0.79,1.03,1.06,0.4,0.4,
     0.68,0.66,0.86,0.82,0.39,0.43,0.77,0.76,0.86,0.85,
     0.41,0.4,0.85,0.84,1.01,0.98)
tot.data<-data.frame(Y=Y,G=G,O=O,D=D)
anova.result<-EMS.anova(data.tot=tot.data,
                        Y.name="Y",
                        var.list=c("G","O","D"),
                        FixRan.list=c("F","R","R"))
anova.result                         
Approx.F(SS.table=anova.result,approx.id=1) 
EMS.anova(data.tot=tot.data,
          Y.name="Y",
          var.list=c("G","O","D"),
          FixRan.list=c("F","R","R"),
          approx.flag=TRUE)                      
       
}

