% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggm.R
\name{rhogrid}
\alias{rhogrid}
\title{Create sequence of possible tuning parameter values}
\usage{
rhogrid(
  n.rho,
  method = c("qgraph", "glassopath"),
  rho.min.ratio = 0.01,
  dat = NULL,
  S = NULL,
  ...
)
}
\arguments{
\item{n.rho}{Integer corresponding to the number of tuning parameter values.}

\item{method}{Character corresponding to the method to create tuning parameter values ("qgraph" or "glassopath"); see Details.}

\item{rho.min.ratio}{Numeric value that mimics \code{\link[qgraph]{EBICglasso}} behavior for tuning parameter.
i.e., "Ratio of lowest (tuning parameter) compared to maximal (tuning parameter)".}

\item{dat}{The raw data, if \code{S} is not provided used to estimate \code{S}. Not required if \code{S} is provided.}

\item{S}{Covariance matrix for the data. If provided, supersedes \code{dat}.}

\item{...}{Other arguments passed down to \code{\link{em.prec}}.}
}
\value{
A vector of possible tuning parameter values.
}
\description{
Create sequence of possible tuning parameter values
}
\details{
For regularized estimation of the Gaussian graphical model, a sequence or grid of possible tuning
parameter values is often tried, with the tuning parameter that optimizes some criterion (EBIC, k-fold
cross validation) chosen. This is an attempt to automate some of the sequence creation. Code
is borrowed from qgraph and glasso, acknowledged in references below. Both require some estimate
of the covariance matrix in order to do regularization; if not provided, \code{\link{em.prec}} with
default options is attempted.

For "qgraph" the max value is determined by the maximum absolute value of the
difference between the covariance matrix and an identity matrix. The min is \code{rho.min.ratio}
times the max value. A sequence that is equally spaced on a log scale is then constructed between
these two values.

For "glassopath", the max value is the max absolute value of the covariance matrix. The min is
the max divided by the number of desired tuning parameter values. A sequence that is equally spaced
between these two values is then constructed.
}
\examples{
\donttest{
library(psych)
data(bfi)

# pick 50 values using the approach qgraph uses; give data as input 
rho <- rhogrid(50, method="qgraph", dat = bfi[,1:25])

emresult <- em.cov(bfi[,1:25])
S<-emresult$S

# pick 50 values using the approach glasso uses; give S as input
rho2 <- rhogrid(50, method="glassopath", S = S)

}
}
\references{
qgraph:
Epskamp, S., Cramer, A., Waldorp, L., Schmittmann, V. D., & Borsboom, D. (2012). qgraph: Network visualizations of relationships in psychometric data. Journal of Statistical Software, 48 (1), 1-18.

glasso (i.e., glassopath option):
Friedman, J. H., Hastie, T., & Tibshirani, R. (2014). glasso: Graphical lasso estimation of Gaussian graphical models.
  Retrieved from https://CRAN.R-project.org/package=glasso
}
