% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raster.cor.R
\name{raster.cor}
\alias{raster.cor}
\title{Calculates the correlation coefficient between two rasters.}
\usage{
raster.cor(x, y, method = "spearman")
}
\arguments{
\item{x}{Either a raster or an ENMTools model object with a suitability raster.}

\item{y}{Either a raster or an ENMTools model object with a suitability raster.}

\item{method}{The method to be used for calculating correlations.  Defaults to spearman, but can take "kendall" or "pearson" as well.}
}
\value{
A numeric correlation coefficient.
}
\description{
Calculates the correlation coefficient between two rasters.
}
\examples{
data(euro.worldclim)
raster.cor(euro.worldclim[[1]], euro.worldclim[[2]])
}
