% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EQRN_network_structures.R
\name{FC_GPD_SNN}
\alias{FC_GPD_SNN}
\title{Self-normalized fully-connected network module for GPD parameter prediction}
\usage{
FC_GPD_SNN(D_in, Hidden_vect = c(64, 64, 64), p_drop = 0.01)
}
\arguments{
\item{D_in}{the input size (i.e. the number of features),}

\item{Hidden_vect}{a vector of integers whose length determines the number of layers in the neural network
and entries the number of neurons in each corresponding successive layer,}

\item{p_drop}{probability parameter for the \code{alpha-dropout} before each hidden layer for regularization during training.}
}
\value{
The specified SNN MLP GPD network as a \code{\link[torch:nn_module]{torch::nn_module}}.
}
\description{
A fully-connected self-normalizing network as a \code{\link[torch:nn_module]{torch::nn_module}},
designed for generalized Pareto distribution parameter prediction.
}
\details{
The constructor allows specifying:
\describe{
\item{D_in}{the input size (i.e. the number of features),}
\item{Hidden_vect}{a vector of integers whose length determines the number of layers in the neural network
and entries the number of neurons in each corresponding successive layer,}
\item{p_drop}{probability parameter for the \code{alpha-dropout} before each hidden layer for regularization during training.}
}
}
\references{
Gunter Klambauer, Thomas Unterthiner, Andreas Mayr, Sepp Hochreiter. Self-Normalizing Neural Networks.
Advances in Neural Information Processing Systems 30 (NIPS 2017), 2017.
}
