% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EVT_utils.R
\name{GPD_excess_probability}
\alias{GPD_excess_probability}
\title{Tail excess probability prediction based on conditional GPD parameters}
\usage{
GPD_excess_probability(
  val,
  sigma,
  xi,
  interm_threshold,
  threshold_p,
  body_proba = "default",
  proba_type = c("excess", "cdf")
)
}
\arguments{
\item{val}{Quantile value(s) used to estimate the conditional excess probability or cdf.}

\item{sigma}{Value(s) for the GPD scale parameter.}

\item{xi}{Value(s) for the GPD shape parameter.}

\item{interm_threshold}{Intermediate (conditional) quantile(s) at level \code{threshold_p} used as a (varying) threshold.}

\item{threshold_p}{Probability level of the intermediate conditional quantiles \code{interm_threshold}.}

\item{body_proba}{Value to use when the predicted conditional probability is below \code{threshold_p}
(in which case it cannot be precisely assessed by the model).
If \code{"default"} is given (the default), \code{paste0(">",1-threshold_p)} is used if \code{proba_type=="excess"},
and \code{paste0("<",threshold_p)} is used if \code{proba_type=="cdf"}.}

\item{proba_type}{Whether to return the \code{"excess"} probability over \code{val} (default) or the \code{"cdf"} at \code{val}.}
}
\value{
Vector of probabilities (and possibly a few \code{body_proba} values if \code{val} is not large enough)
of the same length as the longest vector between \code{val}, \code{sigma}, \code{xi} and \code{interm_threshold}.
}
\description{
Tail excess probability prediction based on conditional GPD parameters
}
