\name{function.plan_upload_no_data}
\alias{function.plan_upload_no_data}
\title{
Upload a Plan to Rerun the Analysis without Data Upload
}
\description{
Once an analysis has been performed, a plan is automatically generated by 'EQUAL-STATS'. This plan can be used to rerun the analysis allowing transparency and reproducibility of analysis. For this function to run successfully, additional information is provided directly by 'EQUAL-STATS' software. For analysis requiring data upload, \code{\link[=function.plan_upload]{function.plan_upload()}} is used
}
\usage{
function.plan_upload_no_data(plan_file_path, rv)
}
\arguments{
\item{plan_file_path}{The path to the plan file.}
\item{rv}{A list supplied by 'EQUAL-STATS' application based on user input.}
}
\value{
Depending upon whether the plan aligned to the data uploaded, either the results of the analysis or message for reason for failure is provided.
}
\references{
\url{https://sites.google.com/view/equal-group/home}
}
\author{
Kurinchi Gurusamy
}
\note{
This is part of a suite of functions required to allow 'EQUAL-STATS' program to run. This is unlikely to be used as a stand alone function.
}
\seealso{
\code{\link[=function.plan_upload]{function.plan_upload()}}
}
\concept{ EQUAL-STATS }
\examples{
# This requires several additional functions to complete successfully.
# Therefore, column names was altered to demonstrate the unsuccessful results.
# Create plan
plan <- cbind.data.frame(
"AN0001", "Generate_Hypothesis", "", "Intensive rehabilitation", "Standard rehabilitation",
"Intervention is better or worse than comparator", "Mobility score",
"Higher values of the outcome (or more events) are better for the subject", "10",
"", "", "", "", "", "", "", "", "", "")
colnames(plan) <- c(
"analysis_number", "menu_choice", "second_menu_choice", "entry_1", "entry_2", "entry_3",
"entry_4", "entry_5", "entry_6", "entry_7", "entry_8", "entry_9", "entry_10",
"entry_11", "entry_12", "entry_13", "entry_14", "entry_15", "same_row_different_row")
# Simulate lists provided by EQUAL-STATS ####
Predefined_lists <- list(
  main_menu = c(
    'Calculate summary measures',
    'Create plots',
    'Check distribution',
    'Compare sample mean versus population mean',
    'Compare groups/variables (independent samples)',
    'Compare groups/variables (paired samples or repeated measures)',
    'Find the correlation (quantitative variables)',
    'Calculate measurement error',
    'Find the diagnostic accuracy (primary data)',
    'Perform sample size and power calculations (primary data)',
    'Perform survival analysis',
    'Perform regression analysis',
    'Analyse time series',
    'Perform mixed-effects regression',
    'Perform multivariate regression',
    'Generate hypothesis',
    'Perform sample size and power calculations (effect size approach)',
    'Make correct conclusions (effect size approach)',
    'Find the diagnostic accuracy (tabulated data)'
  ),
  menu_short = c(
    'Summary_Measures',
    'Create_Plots',
    'Check_Distribution',
    'Compare_Sample_Pop_Means',
    'Compare_Groups',
    'Repeated_Measures',
    'Correlation',
    'Measurement_Error',
    'Diagnostic_Accuracy_Primary',
    'Sample_Size_Calculations_Primary',
    'Survival_Analysis',
    'Regression_Analysis',
    'Time_Series',
    'Mixed_Effects_Regression',
    'Multivariate_Regression',
    'Generate_Hypothesis',
    'Sample_Size_Calculations_Effect_size',
    'Make_Conclusions_Effect_size',
    'Diagnostic_Accuracy_Tables'
  )
)
entry <- list()
entry <- lapply(1:15, function(x) entry[[x]] <- '')
rv <- list(
  StorageFolder = tempdir(),
  first_menu_choice = NA,
  second_menu_choice = NA,
  entry = entry,
  import_data = NULL,
  same_row_different_row = NA,
  submit_button_to_appear = FALSE,
  summary_measures_choices = c("EQUAL-STATS choice", "Total observations",
  "Missing observations", "Available observations"),
  analysis_outcome = list(),
  code = list(),
  plan = list(),
  results = list(),
  plots_list = list(),
  reports = list()
)
no_data_choices <- c("Generate_Hypothesis", "Sample_Size_Calculations_Effect_size",
"Make_Conclusions_Effect_size", "Diagnostic_Accuracy_Tables")
# Store the plan
plan_file_path = paste0(tempdir(), "/plan.csv")
write.csv(plan, file = plan_file_path, row.names = FALSE, na = "")
# Load the necessary packages and functions
library(stringr)
# Final function ####
plan_outcome <- function.plan_upload_no_data(plan_file_path, rv)
}
