% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biases.R
\name{selection}
\alias{selection}
\title{Selection bias}
\usage{
selection(..., verbose = FALSE)
}
\arguments{
\item{...}{Optional arguments describing the type of potential selection
bias. Options are "general" (general selection bias, the default if no
options are chosen), "increased risk" and "decreased risk" (assumptions
about the direction of risk in the selected population), "S = U"
(simplification used if the biasing characteristic is common to the entire
selected population), and "selected" (when the target of inference is the
selected population only). Errors are produced when incompatible
assumptions are chosen.}

\item{verbose}{Logical. If \code{TRUE}, returns warnings and messages immediately.
Defaults to \code{FALSE} because it is generally used within the \code{\link[=multi_bias]{multi_bias()}}
function, which will print the same messages/warnings.}
}
\value{
Invisibly returns a list with components whose values depend on the
options chosen: \code{n} (the degree of the polynomial in the numerator), \code{d}
(the degree of the polynomial in the denominator),\code{mess} (any
messages/warnings that should be printed for the user), and
\code{bias}("selection").
}
\description{
A type of bias. Declares that selection bias will be a component
of interest in the multi-bias sensitivity analysis. Generally used within
other functions; its output is returned invisibly.
}
\examples{
# returns invisibly without print()
print(selection("general", "increased risk"))

# Calculate an E-value for selection bias only
multi_evalue(est = RR(4),
         biases = selection("general", "increased risk"))

}
\keyword{multi-bias}
