// Generated by rstantools.  Do not edit by hand.

/*
    EcoEnsemble is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    EcoEnsemble is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with EcoEnsemble.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_ensemble_prior_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_ensemble_prior");
    reader.add_event(263, 261, "end", "model_ensemble_prior");
    return reader;
}
template <typename T0__>
typename boost::math::tools::promote_args<T0__>::type
As(const T0__& Rho, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        current_statement_begin__ = 6;
        return stan::math::promote_scalar<fun_return_scalar_t__>((((1 / stan::math::pi()) * stan::math::atan((Rho / stan::math::sqrt((1 - pow(Rho, 2)))))) + 0.5));
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct As_functor__ {
    template <typename T0__>
        typename boost::math::tools::promote_args<T0__>::type
    operator()(const T0__& Rho, std::ostream* pstream__) const {
        return As(Rho, pstream__);
    }
};
template <typename T0__, typename T2__, typename T3__>
typename boost::math::tools::promote_args<T0__, T2__, T3__>::type
priors_cor_beta(const Eigen::Matrix<T0__, Eigen::Dynamic, Eigen::Dynamic>& Rho,
                    const int& N,
                    const Eigen::Matrix<T2__, Eigen::Dynamic, Eigen::Dynamic>& beta_1,
                    const Eigen::Matrix<T3__, Eigen::Dynamic, Eigen::Dynamic>& beta_2, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T2__, T3__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 13;
        local_scalar_t__ log_prior(DUMMY_VAR__);
        (void) log_prior;  // dummy to suppress unused var warning
        stan::math::initialize(log_prior, DUMMY_VAR__);
        stan::math::fill(log_prior, DUMMY_VAR__);
        current_statement_begin__ = 14;
        stan::math::assign(log_prior, 0);
        current_statement_begin__ = 15;
        for (int i = 1; i <= (N - 1); ++i) {
            current_statement_begin__ = 16;
            for (int j = (i + 1); j <= N; ++j) {
                current_statement_begin__ = 17;
                stan::math::assign(log_prior, (log_prior + beta_log(As(get_base1(Rho, i, j, "Rho", 1), pstream__), get_base1(beta_1, i, j, "beta_1", 1), get_base1(beta_2, i, j, "beta_2", 1))));
            }
        }
        current_statement_begin__ = 20;
        return stan::math::promote_scalar<fun_return_scalar_t__>(log_prior);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct priors_cor_beta_functor__ {
    template <typename T0__, typename T2__, typename T3__>
        typename boost::math::tools::promote_args<T0__, T2__, T3__>::type
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, Eigen::Dynamic>& Rho,
                    const int& N,
                    const Eigen::Matrix<T2__, Eigen::Dynamic, Eigen::Dynamic>& beta_1,
                    const Eigen::Matrix<T3__, Eigen::Dynamic, Eigen::Dynamic>& beta_2, std::ostream* pstream__) const {
        return priors_cor_beta(Rho, N, beta_1, beta_2, pstream__);
    }
};
template <typename T0__, typename T2__>
typename boost::math::tools::promote_args<T0__, T2__>::type
priors_cor_hierarchical_beta(const Eigen::Matrix<T0__, Eigen::Dynamic, Eigen::Dynamic>& ind_st_cor,
                                 const int& N,
                                 const Eigen::Matrix<T2__, Eigen::Dynamic, Eigen::Dynamic>& M, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T2__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 27;
        local_scalar_t__ log_prior(DUMMY_VAR__);
        (void) log_prior;  // dummy to suppress unused var warning
        stan::math::initialize(log_prior, DUMMY_VAR__);
        stan::math::fill(log_prior, DUMMY_VAR__);
        stan::math::assign(log_prior,0);
        current_statement_begin__ = 28;
        for (int i = 1; i <= (N - 1); ++i) {
            current_statement_begin__ = 29;
            for (int j = (i + 1); j <= N; ++j) {
                current_statement_begin__ = 30;
                stan::math::assign(log_prior, (log_prior + beta_log((0.5 * (get_base1(ind_st_cor, i, j, "ind_st_cor", 1) + 1)), get_base1(M, i, j, "M", 1), get_base1(M, j, i, "M", 1))));
            }
        }
        current_statement_begin__ = 33;
        return stan::math::promote_scalar<fun_return_scalar_t__>(log_prior);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct priors_cor_hierarchical_beta_functor__ {
    template <typename T0__, typename T2__>
        typename boost::math::tools::promote_args<T0__, T2__>::type
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, Eigen::Dynamic>& ind_st_cor,
                                 const int& N,
                                 const Eigen::Matrix<T2__, Eigen::Dynamic, Eigen::Dynamic>& M, std::ostream* pstream__) const {
        return priors_cor_hierarchical_beta(ind_st_cor, N, M, pstream__);
    }
};
int
sq_int(const std::vector<int>& model_num_species,
           const int& M, std::ostream* pstream__) {
    typedef double local_scalar_t__;
    typedef int fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 37;
        int ret(0);
        (void) ret;  // dummy to suppress unused var warning
        stan::math::fill(ret, std::numeric_limits<int>::min());
        stan::math::assign(ret,0);
        current_statement_begin__ = 38;
        for (int i = 1; i <= M; ++i) {
            current_statement_begin__ = 39;
            stan::math::assign(ret, (ret + (get_base1(model_num_species, i, "model_num_species", 1) * get_base1(model_num_species, i, "model_num_species", 1))));
        }
        current_statement_begin__ = 41;
        return stan::math::promote_scalar<fun_return_scalar_t__>(ret);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct sq_int_functor__ {
            int
    operator()(const std::vector<int>& model_num_species,
           const int& M, std::ostream* pstream__) const {
        return sq_int(model_num_species, M, pstream__);
    }
};
#include <stan_meta_header.hpp>
class model_ensemble_prior
  : public stan::model::model_base_crtp<model_ensemble_prior> {
private:
        int N;
        int M;
        int form_prior_ind_st;
        int form_prior_ind_lt;
        int form_prior_sha_st;
        vector_d prior_ind_st_var_a;
        vector_d prior_ind_st_var_b;
        std::vector<double> prior_ind_st_cor_lkj;
        matrix_d prior_ind_st_cor_wish_sigma;
        std::vector<double> prior_ind_st_cor_wish_nu;
        matrix_d prior_ind_st_cor_beta_1;
        matrix_d prior_ind_st_cor_beta_2;
        vector_d prior_ind_st_cor_hierarchical_beta_hyper_params;
        vector_d prior_ind_st_var_hierarchical_hyperparams;
        double prior_ind_st_ar_alpha;
        double prior_ind_st_ar_beta;
        vector_d prior_ind_lt_var_a;
        vector_d prior_ind_lt_var_b;
        std::vector<double> prior_ind_lt_cor_lkj;
        matrix_d prior_ind_lt_cor_wish_sigma;
        std::vector<double> prior_ind_lt_cor_wish_nu;
        matrix_d prior_ind_lt_cor_beta_1;
        matrix_d prior_ind_lt_cor_beta_2;
        vector_d prior_sha_st_var_a;
        vector_d prior_sha_st_var_b;
        std::vector<double> prior_sha_st_cor_lkj;
        matrix_d prior_sha_st_cor_wish_sigma;
        std::vector<double> prior_sha_st_cor_wish_nu;
        matrix_d prior_sha_st_cor_beta_1;
        matrix_d prior_sha_st_cor_beta_2;
        double prior_sha_st_ar_alpha;
        double prior_sha_st_ar_beta;
        vector_d prior_sha_lt_sd;
        vector_d prior_y_init_mean;
        vector_d prior_y_init_var;
        double prior_sigma_t_inv_wish_nu;
        matrix_d prior_sigma_t_inv_wish_sigma;
public:
    model_ensemble_prior(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_ensemble_prior(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_ensemble_prior_namespace::model_ensemble_prior";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 46;
            context__.validate_dims("data initialization", "N", "int", context__.to_vec());
            N = int(0);
            vals_i__ = context__.vals_i("N");
            pos__ = 0;
            N = vals_i__[pos__++];
            check_greater_or_equal(function__, "N", N, 0);
            current_statement_begin__ = 58;
            context__.validate_dims("data initialization", "M", "int", context__.to_vec());
            M = int(0);
            vals_i__ = context__.vals_i("M");
            pos__ = 0;
            M = vals_i__[pos__++];
            check_greater_or_equal(function__, "M", M, 0);
            current_statement_begin__ = 77;
            context__.validate_dims("data initialization", "form_prior_ind_st", "int", context__.to_vec());
            form_prior_ind_st = int(0);
            vals_i__ = context__.vals_i("form_prior_ind_st");
            pos__ = 0;
            form_prior_ind_st = vals_i__[pos__++];
            check_greater_or_equal(function__, "form_prior_ind_st", form_prior_ind_st, 0);
            check_less_or_equal(function__, "form_prior_ind_st", form_prior_ind_st, 3);
            current_statement_begin__ = 78;
            context__.validate_dims("data initialization", "form_prior_ind_lt", "int", context__.to_vec());
            form_prior_ind_lt = int(0);
            vals_i__ = context__.vals_i("form_prior_ind_lt");
            pos__ = 0;
            form_prior_ind_lt = vals_i__[pos__++];
            check_greater_or_equal(function__, "form_prior_ind_lt", form_prior_ind_lt, 0);
            check_less_or_equal(function__, "form_prior_ind_lt", form_prior_ind_lt, 2);
            current_statement_begin__ = 79;
            context__.validate_dims("data initialization", "form_prior_sha_st", "int", context__.to_vec());
            form_prior_sha_st = int(0);
            vals_i__ = context__.vals_i("form_prior_sha_st");
            pos__ = 0;
            form_prior_sha_st = vals_i__[pos__++];
            check_greater_or_equal(function__, "form_prior_sha_st", form_prior_sha_st, 0);
            check_less_or_equal(function__, "form_prior_sha_st", form_prior_sha_st, 2);
            current_statement_begin__ = 86;
            validate_non_negative_index("prior_ind_st_var_a", "N", N);
            context__.validate_dims("data initialization", "prior_ind_st_var_a", "vector_d", context__.to_vec(N));
            prior_ind_st_var_a = Eigen::Matrix<double, Eigen::Dynamic, 1>(N);
            vals_r__ = context__.vals_r("prior_ind_st_var_a");
            pos__ = 0;
            size_t prior_ind_st_var_a_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < prior_ind_st_var_a_j_1_max__; ++j_1__) {
                prior_ind_st_var_a(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 87;
            validate_non_negative_index("prior_ind_st_var_b", "N", N);
            context__.validate_dims("data initialization", "prior_ind_st_var_b", "vector_d", context__.to_vec(N));
            prior_ind_st_var_b = Eigen::Matrix<double, Eigen::Dynamic, 1>(N);
            vals_r__ = context__.vals_r("prior_ind_st_var_b");
            pos__ = 0;
            size_t prior_ind_st_var_b_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < prior_ind_st_var_b_j_1_max__; ++j_1__) {
                prior_ind_st_var_b(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 88;
            validate_non_negative_index("prior_ind_st_cor_lkj", "(logical_eq(form_prior_ind_st, 0) ? 1 : 0 )", (logical_eq(form_prior_ind_st, 0) ? 1 : 0 ));
            context__.validate_dims("data initialization", "prior_ind_st_cor_lkj", "double", context__.to_vec((logical_eq(form_prior_ind_st, 0) ? 1 : 0 )));
            prior_ind_st_cor_lkj = std::vector<double>((logical_eq(form_prior_ind_st, 0) ? 1 : 0 ), double(0));
            vals_r__ = context__.vals_r("prior_ind_st_cor_lkj");
            pos__ = 0;
            size_t prior_ind_st_cor_lkj_k_0_max__ = (logical_eq(form_prior_ind_st, 0) ? 1 : 0 );
            for (size_t k_0__ = 0; k_0__ < prior_ind_st_cor_lkj_k_0_max__; ++k_0__) {
                prior_ind_st_cor_lkj[k_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 89;
            validate_non_negative_index("prior_ind_st_cor_wish_sigma", "(logical_eq(form_prior_ind_st, 1) ? N : 0 )", (logical_eq(form_prior_ind_st, 1) ? N : 0 ));
            validate_non_negative_index("prior_ind_st_cor_wish_sigma", "(logical_eq(form_prior_ind_st, 1) ? N : 0 )", (logical_eq(form_prior_ind_st, 1) ? N : 0 ));
            context__.validate_dims("data initialization", "prior_ind_st_cor_wish_sigma", "matrix_d", context__.to_vec((logical_eq(form_prior_ind_st, 1) ? N : 0 ),(logical_eq(form_prior_ind_st, 1) ? N : 0 )));
            prior_ind_st_cor_wish_sigma = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>((logical_eq(form_prior_ind_st, 1) ? N : 0 ), (logical_eq(form_prior_ind_st, 1) ? N : 0 ));
            vals_r__ = context__.vals_r("prior_ind_st_cor_wish_sigma");
            pos__ = 0;
            size_t prior_ind_st_cor_wish_sigma_j_2_max__ = (logical_eq(form_prior_ind_st, 1) ? N : 0 );
            size_t prior_ind_st_cor_wish_sigma_j_1_max__ = (logical_eq(form_prior_ind_st, 1) ? N : 0 );
            for (size_t j_2__ = 0; j_2__ < prior_ind_st_cor_wish_sigma_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < prior_ind_st_cor_wish_sigma_j_1_max__; ++j_1__) {
                    prior_ind_st_cor_wish_sigma(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 90;
            validate_non_negative_index("prior_ind_st_cor_wish_nu", "(logical_eq(form_prior_ind_st, 1) ? 1 : 0 )", (logical_eq(form_prior_ind_st, 1) ? 1 : 0 ));
            context__.validate_dims("data initialization", "prior_ind_st_cor_wish_nu", "double", context__.to_vec((logical_eq(form_prior_ind_st, 1) ? 1 : 0 )));
            prior_ind_st_cor_wish_nu = std::vector<double>((logical_eq(form_prior_ind_st, 1) ? 1 : 0 ), double(0));
            vals_r__ = context__.vals_r("prior_ind_st_cor_wish_nu");
            pos__ = 0;
            size_t prior_ind_st_cor_wish_nu_k_0_max__ = (logical_eq(form_prior_ind_st, 1) ? 1 : 0 );
            for (size_t k_0__ = 0; k_0__ < prior_ind_st_cor_wish_nu_k_0_max__; ++k_0__) {
                prior_ind_st_cor_wish_nu[k_0__] = vals_r__[pos__++];
            }
            size_t prior_ind_st_cor_wish_nu_i_0_max__ = (logical_eq(form_prior_ind_st, 1) ? 1 : 0 );
            for (size_t i_0__ = 0; i_0__ < prior_ind_st_cor_wish_nu_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "prior_ind_st_cor_wish_nu[i_0__]", prior_ind_st_cor_wish_nu[i_0__], (N - 1));
            }
            current_statement_begin__ = 91;
            validate_non_negative_index("prior_ind_st_cor_beta_1", "(logical_eq(form_prior_ind_st, 2) ? N : 0 )", (logical_eq(form_prior_ind_st, 2) ? N : 0 ));
            validate_non_negative_index("prior_ind_st_cor_beta_1", "(logical_eq(form_prior_ind_st, 2) ? N : 0 )", (logical_eq(form_prior_ind_st, 2) ? N : 0 ));
            context__.validate_dims("data initialization", "prior_ind_st_cor_beta_1", "matrix_d", context__.to_vec((logical_eq(form_prior_ind_st, 2) ? N : 0 ),(logical_eq(form_prior_ind_st, 2) ? N : 0 )));
            prior_ind_st_cor_beta_1 = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>((logical_eq(form_prior_ind_st, 2) ? N : 0 ), (logical_eq(form_prior_ind_st, 2) ? N : 0 ));
            vals_r__ = context__.vals_r("prior_ind_st_cor_beta_1");
            pos__ = 0;
            size_t prior_ind_st_cor_beta_1_j_2_max__ = (logical_eq(form_prior_ind_st, 2) ? N : 0 );
            size_t prior_ind_st_cor_beta_1_j_1_max__ = (logical_eq(form_prior_ind_st, 2) ? N : 0 );
            for (size_t j_2__ = 0; j_2__ < prior_ind_st_cor_beta_1_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < prior_ind_st_cor_beta_1_j_1_max__; ++j_1__) {
                    prior_ind_st_cor_beta_1(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 92;
            validate_non_negative_index("prior_ind_st_cor_beta_2", "(logical_eq(form_prior_ind_st, 2) ? N : 0 )", (logical_eq(form_prior_ind_st, 2) ? N : 0 ));
            validate_non_negative_index("prior_ind_st_cor_beta_2", "(logical_eq(form_prior_ind_st, 2) ? N : 0 )", (logical_eq(form_prior_ind_st, 2) ? N : 0 ));
            context__.validate_dims("data initialization", "prior_ind_st_cor_beta_2", "matrix_d", context__.to_vec((logical_eq(form_prior_ind_st, 2) ? N : 0 ),(logical_eq(form_prior_ind_st, 2) ? N : 0 )));
            prior_ind_st_cor_beta_2 = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>((logical_eq(form_prior_ind_st, 2) ? N : 0 ), (logical_eq(form_prior_ind_st, 2) ? N : 0 ));
            vals_r__ = context__.vals_r("prior_ind_st_cor_beta_2");
            pos__ = 0;
            size_t prior_ind_st_cor_beta_2_j_2_max__ = (logical_eq(form_prior_ind_st, 2) ? N : 0 );
            size_t prior_ind_st_cor_beta_2_j_1_max__ = (logical_eq(form_prior_ind_st, 2) ? N : 0 );
            for (size_t j_2__ = 0; j_2__ < prior_ind_st_cor_beta_2_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < prior_ind_st_cor_beta_2_j_1_max__; ++j_1__) {
                    prior_ind_st_cor_beta_2(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 97;
            validate_non_negative_index("prior_ind_st_cor_hierarchical_beta_hyper_params", "(logical_eq(form_prior_ind_st, 3) ? 4 : 0 )", (logical_eq(form_prior_ind_st, 3) ? 4 : 0 ));
            context__.validate_dims("data initialization", "prior_ind_st_cor_hierarchical_beta_hyper_params", "vector_d", context__.to_vec((logical_eq(form_prior_ind_st, 3) ? 4 : 0 )));
            prior_ind_st_cor_hierarchical_beta_hyper_params = Eigen::Matrix<double, Eigen::Dynamic, 1>((logical_eq(form_prior_ind_st, 3) ? 4 : 0 ));
            vals_r__ = context__.vals_r("prior_ind_st_cor_hierarchical_beta_hyper_params");
            pos__ = 0;
            size_t prior_ind_st_cor_hierarchical_beta_hyper_params_j_1_max__ = (logical_eq(form_prior_ind_st, 3) ? 4 : 0 );
            for (size_t j_1__ = 0; j_1__ < prior_ind_st_cor_hierarchical_beta_hyper_params_j_1_max__; ++j_1__) {
                prior_ind_st_cor_hierarchical_beta_hyper_params(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 98;
            validate_non_negative_index("prior_ind_st_var_hierarchical_hyperparams", "(logical_eq(form_prior_ind_st, 3) ? 4 : 0 )", (logical_eq(form_prior_ind_st, 3) ? 4 : 0 ));
            context__.validate_dims("data initialization", "prior_ind_st_var_hierarchical_hyperparams", "vector_d", context__.to_vec((logical_eq(form_prior_ind_st, 3) ? 4 : 0 )));
            prior_ind_st_var_hierarchical_hyperparams = Eigen::Matrix<double, Eigen::Dynamic, 1>((logical_eq(form_prior_ind_st, 3) ? 4 : 0 ));
            vals_r__ = context__.vals_r("prior_ind_st_var_hierarchical_hyperparams");
            pos__ = 0;
            size_t prior_ind_st_var_hierarchical_hyperparams_j_1_max__ = (logical_eq(form_prior_ind_st, 3) ? 4 : 0 );
            for (size_t j_1__ = 0; j_1__ < prior_ind_st_var_hierarchical_hyperparams_j_1_max__; ++j_1__) {
                prior_ind_st_var_hierarchical_hyperparams(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 101;
            context__.validate_dims("data initialization", "prior_ind_st_ar_alpha", "double", context__.to_vec());
            prior_ind_st_ar_alpha = double(0);
            vals_r__ = context__.vals_r("prior_ind_st_ar_alpha");
            pos__ = 0;
            prior_ind_st_ar_alpha = vals_r__[pos__++];
            check_greater_or_equal(function__, "prior_ind_st_ar_alpha", prior_ind_st_ar_alpha, 0);
            current_statement_begin__ = 102;
            context__.validate_dims("data initialization", "prior_ind_st_ar_beta", "double", context__.to_vec());
            prior_ind_st_ar_beta = double(0);
            vals_r__ = context__.vals_r("prior_ind_st_ar_beta");
            pos__ = 0;
            prior_ind_st_ar_beta = vals_r__[pos__++];
            check_greater_or_equal(function__, "prior_ind_st_ar_beta", prior_ind_st_ar_beta, 0);
            current_statement_begin__ = 106;
            validate_non_negative_index("prior_ind_lt_var_a", "N", N);
            context__.validate_dims("data initialization", "prior_ind_lt_var_a", "vector_d", context__.to_vec(N));
            prior_ind_lt_var_a = Eigen::Matrix<double, Eigen::Dynamic, 1>(N);
            vals_r__ = context__.vals_r("prior_ind_lt_var_a");
            pos__ = 0;
            size_t prior_ind_lt_var_a_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < prior_ind_lt_var_a_j_1_max__; ++j_1__) {
                prior_ind_lt_var_a(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 107;
            validate_non_negative_index("prior_ind_lt_var_b", "N", N);
            context__.validate_dims("data initialization", "prior_ind_lt_var_b", "vector_d", context__.to_vec(N));
            prior_ind_lt_var_b = Eigen::Matrix<double, Eigen::Dynamic, 1>(N);
            vals_r__ = context__.vals_r("prior_ind_lt_var_b");
            pos__ = 0;
            size_t prior_ind_lt_var_b_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < prior_ind_lt_var_b_j_1_max__; ++j_1__) {
                prior_ind_lt_var_b(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 108;
            validate_non_negative_index("prior_ind_lt_cor_lkj", "(logical_eq(form_prior_ind_lt, 0) ? 1 : 0 )", (logical_eq(form_prior_ind_lt, 0) ? 1 : 0 ));
            context__.validate_dims("data initialization", "prior_ind_lt_cor_lkj", "double", context__.to_vec((logical_eq(form_prior_ind_lt, 0) ? 1 : 0 )));
            prior_ind_lt_cor_lkj = std::vector<double>((logical_eq(form_prior_ind_lt, 0) ? 1 : 0 ), double(0));
            vals_r__ = context__.vals_r("prior_ind_lt_cor_lkj");
            pos__ = 0;
            size_t prior_ind_lt_cor_lkj_k_0_max__ = (logical_eq(form_prior_ind_lt, 0) ? 1 : 0 );
            for (size_t k_0__ = 0; k_0__ < prior_ind_lt_cor_lkj_k_0_max__; ++k_0__) {
                prior_ind_lt_cor_lkj[k_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 109;
            validate_non_negative_index("prior_ind_lt_cor_wish_sigma", "(logical_eq(form_prior_ind_lt, 1) ? N : 0 )", (logical_eq(form_prior_ind_lt, 1) ? N : 0 ));
            validate_non_negative_index("prior_ind_lt_cor_wish_sigma", "(logical_eq(form_prior_ind_lt, 1) ? N : 0 )", (logical_eq(form_prior_ind_lt, 1) ? N : 0 ));
            context__.validate_dims("data initialization", "prior_ind_lt_cor_wish_sigma", "matrix_d", context__.to_vec((logical_eq(form_prior_ind_lt, 1) ? N : 0 ),(logical_eq(form_prior_ind_lt, 1) ? N : 0 )));
            prior_ind_lt_cor_wish_sigma = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>((logical_eq(form_prior_ind_lt, 1) ? N : 0 ), (logical_eq(form_prior_ind_lt, 1) ? N : 0 ));
            vals_r__ = context__.vals_r("prior_ind_lt_cor_wish_sigma");
            pos__ = 0;
            size_t prior_ind_lt_cor_wish_sigma_j_2_max__ = (logical_eq(form_prior_ind_lt, 1) ? N : 0 );
            size_t prior_ind_lt_cor_wish_sigma_j_1_max__ = (logical_eq(form_prior_ind_lt, 1) ? N : 0 );
            for (size_t j_2__ = 0; j_2__ < prior_ind_lt_cor_wish_sigma_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < prior_ind_lt_cor_wish_sigma_j_1_max__; ++j_1__) {
                    prior_ind_lt_cor_wish_sigma(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 110;
            validate_non_negative_index("prior_ind_lt_cor_wish_nu", "(logical_eq(form_prior_ind_lt, 1) ? 1 : 0 )", (logical_eq(form_prior_ind_lt, 1) ? 1 : 0 ));
            context__.validate_dims("data initialization", "prior_ind_lt_cor_wish_nu", "double", context__.to_vec((logical_eq(form_prior_ind_lt, 1) ? 1 : 0 )));
            prior_ind_lt_cor_wish_nu = std::vector<double>((logical_eq(form_prior_ind_lt, 1) ? 1 : 0 ), double(0));
            vals_r__ = context__.vals_r("prior_ind_lt_cor_wish_nu");
            pos__ = 0;
            size_t prior_ind_lt_cor_wish_nu_k_0_max__ = (logical_eq(form_prior_ind_lt, 1) ? 1 : 0 );
            for (size_t k_0__ = 0; k_0__ < prior_ind_lt_cor_wish_nu_k_0_max__; ++k_0__) {
                prior_ind_lt_cor_wish_nu[k_0__] = vals_r__[pos__++];
            }
            size_t prior_ind_lt_cor_wish_nu_i_0_max__ = (logical_eq(form_prior_ind_lt, 1) ? 1 : 0 );
            for (size_t i_0__ = 0; i_0__ < prior_ind_lt_cor_wish_nu_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "prior_ind_lt_cor_wish_nu[i_0__]", prior_ind_lt_cor_wish_nu[i_0__], (N - 1));
            }
            current_statement_begin__ = 111;
            validate_non_negative_index("prior_ind_lt_cor_beta_1", "(logical_eq(form_prior_ind_lt, 2) ? N : 0 )", (logical_eq(form_prior_ind_lt, 2) ? N : 0 ));
            validate_non_negative_index("prior_ind_lt_cor_beta_1", "(logical_eq(form_prior_ind_lt, 2) ? N : 0 )", (logical_eq(form_prior_ind_lt, 2) ? N : 0 ));
            context__.validate_dims("data initialization", "prior_ind_lt_cor_beta_1", "matrix_d", context__.to_vec((logical_eq(form_prior_ind_lt, 2) ? N : 0 ),(logical_eq(form_prior_ind_lt, 2) ? N : 0 )));
            prior_ind_lt_cor_beta_1 = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>((logical_eq(form_prior_ind_lt, 2) ? N : 0 ), (logical_eq(form_prior_ind_lt, 2) ? N : 0 ));
            vals_r__ = context__.vals_r("prior_ind_lt_cor_beta_1");
            pos__ = 0;
            size_t prior_ind_lt_cor_beta_1_j_2_max__ = (logical_eq(form_prior_ind_lt, 2) ? N : 0 );
            size_t prior_ind_lt_cor_beta_1_j_1_max__ = (logical_eq(form_prior_ind_lt, 2) ? N : 0 );
            for (size_t j_2__ = 0; j_2__ < prior_ind_lt_cor_beta_1_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < prior_ind_lt_cor_beta_1_j_1_max__; ++j_1__) {
                    prior_ind_lt_cor_beta_1(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 112;
            validate_non_negative_index("prior_ind_lt_cor_beta_2", "(logical_eq(form_prior_ind_lt, 2) ? N : 0 )", (logical_eq(form_prior_ind_lt, 2) ? N : 0 ));
            validate_non_negative_index("prior_ind_lt_cor_beta_2", "(logical_eq(form_prior_ind_lt, 2) ? N : 0 )", (logical_eq(form_prior_ind_lt, 2) ? N : 0 ));
            context__.validate_dims("data initialization", "prior_ind_lt_cor_beta_2", "matrix_d", context__.to_vec((logical_eq(form_prior_ind_lt, 2) ? N : 0 ),(logical_eq(form_prior_ind_lt, 2) ? N : 0 )));
            prior_ind_lt_cor_beta_2 = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>((logical_eq(form_prior_ind_lt, 2) ? N : 0 ), (logical_eq(form_prior_ind_lt, 2) ? N : 0 ));
            vals_r__ = context__.vals_r("prior_ind_lt_cor_beta_2");
            pos__ = 0;
            size_t prior_ind_lt_cor_beta_2_j_2_max__ = (logical_eq(form_prior_ind_lt, 2) ? N : 0 );
            size_t prior_ind_lt_cor_beta_2_j_1_max__ = (logical_eq(form_prior_ind_lt, 2) ? N : 0 );
            for (size_t j_2__ = 0; j_2__ < prior_ind_lt_cor_beta_2_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < prior_ind_lt_cor_beta_2_j_1_max__; ++j_1__) {
                    prior_ind_lt_cor_beta_2(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 117;
            validate_non_negative_index("prior_sha_st_var_a", "N", N);
            context__.validate_dims("data initialization", "prior_sha_st_var_a", "vector_d", context__.to_vec(N));
            prior_sha_st_var_a = Eigen::Matrix<double, Eigen::Dynamic, 1>(N);
            vals_r__ = context__.vals_r("prior_sha_st_var_a");
            pos__ = 0;
            size_t prior_sha_st_var_a_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < prior_sha_st_var_a_j_1_max__; ++j_1__) {
                prior_sha_st_var_a(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 118;
            validate_non_negative_index("prior_sha_st_var_b", "N", N);
            context__.validate_dims("data initialization", "prior_sha_st_var_b", "vector_d", context__.to_vec(N));
            prior_sha_st_var_b = Eigen::Matrix<double, Eigen::Dynamic, 1>(N);
            vals_r__ = context__.vals_r("prior_sha_st_var_b");
            pos__ = 0;
            size_t prior_sha_st_var_b_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < prior_sha_st_var_b_j_1_max__; ++j_1__) {
                prior_sha_st_var_b(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 119;
            validate_non_negative_index("prior_sha_st_cor_lkj", "(logical_eq(form_prior_sha_st, 0) ? 1 : 0 )", (logical_eq(form_prior_sha_st, 0) ? 1 : 0 ));
            context__.validate_dims("data initialization", "prior_sha_st_cor_lkj", "double", context__.to_vec((logical_eq(form_prior_sha_st, 0) ? 1 : 0 )));
            prior_sha_st_cor_lkj = std::vector<double>((logical_eq(form_prior_sha_st, 0) ? 1 : 0 ), double(0));
            vals_r__ = context__.vals_r("prior_sha_st_cor_lkj");
            pos__ = 0;
            size_t prior_sha_st_cor_lkj_k_0_max__ = (logical_eq(form_prior_sha_st, 0) ? 1 : 0 );
            for (size_t k_0__ = 0; k_0__ < prior_sha_st_cor_lkj_k_0_max__; ++k_0__) {
                prior_sha_st_cor_lkj[k_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 120;
            validate_non_negative_index("prior_sha_st_cor_wish_sigma", "(logical_eq(form_prior_sha_st, 1) ? N : 0 )", (logical_eq(form_prior_sha_st, 1) ? N : 0 ));
            validate_non_negative_index("prior_sha_st_cor_wish_sigma", "(logical_eq(form_prior_sha_st, 1) ? N : 0 )", (logical_eq(form_prior_sha_st, 1) ? N : 0 ));
            context__.validate_dims("data initialization", "prior_sha_st_cor_wish_sigma", "matrix_d", context__.to_vec((logical_eq(form_prior_sha_st, 1) ? N : 0 ),(logical_eq(form_prior_sha_st, 1) ? N : 0 )));
            prior_sha_st_cor_wish_sigma = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>((logical_eq(form_prior_sha_st, 1) ? N : 0 ), (logical_eq(form_prior_sha_st, 1) ? N : 0 ));
            vals_r__ = context__.vals_r("prior_sha_st_cor_wish_sigma");
            pos__ = 0;
            size_t prior_sha_st_cor_wish_sigma_j_2_max__ = (logical_eq(form_prior_sha_st, 1) ? N : 0 );
            size_t prior_sha_st_cor_wish_sigma_j_1_max__ = (logical_eq(form_prior_sha_st, 1) ? N : 0 );
            for (size_t j_2__ = 0; j_2__ < prior_sha_st_cor_wish_sigma_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < prior_sha_st_cor_wish_sigma_j_1_max__; ++j_1__) {
                    prior_sha_st_cor_wish_sigma(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 121;
            validate_non_negative_index("prior_sha_st_cor_wish_nu", "(logical_eq(form_prior_sha_st, 1) ? 1 : 0 )", (logical_eq(form_prior_sha_st, 1) ? 1 : 0 ));
            context__.validate_dims("data initialization", "prior_sha_st_cor_wish_nu", "double", context__.to_vec((logical_eq(form_prior_sha_st, 1) ? 1 : 0 )));
            prior_sha_st_cor_wish_nu = std::vector<double>((logical_eq(form_prior_sha_st, 1) ? 1 : 0 ), double(0));
            vals_r__ = context__.vals_r("prior_sha_st_cor_wish_nu");
            pos__ = 0;
            size_t prior_sha_st_cor_wish_nu_k_0_max__ = (logical_eq(form_prior_sha_st, 1) ? 1 : 0 );
            for (size_t k_0__ = 0; k_0__ < prior_sha_st_cor_wish_nu_k_0_max__; ++k_0__) {
                prior_sha_st_cor_wish_nu[k_0__] = vals_r__[pos__++];
            }
            size_t prior_sha_st_cor_wish_nu_i_0_max__ = (logical_eq(form_prior_sha_st, 1) ? 1 : 0 );
            for (size_t i_0__ = 0; i_0__ < prior_sha_st_cor_wish_nu_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "prior_sha_st_cor_wish_nu[i_0__]", prior_sha_st_cor_wish_nu[i_0__], (N - 1));
            }
            current_statement_begin__ = 122;
            validate_non_negative_index("prior_sha_st_cor_beta_1", "(logical_eq(form_prior_sha_st, 2) ? N : 0 )", (logical_eq(form_prior_sha_st, 2) ? N : 0 ));
            validate_non_negative_index("prior_sha_st_cor_beta_1", "(logical_eq(form_prior_sha_st, 2) ? N : 0 )", (logical_eq(form_prior_sha_st, 2) ? N : 0 ));
            context__.validate_dims("data initialization", "prior_sha_st_cor_beta_1", "matrix_d", context__.to_vec((logical_eq(form_prior_sha_st, 2) ? N : 0 ),(logical_eq(form_prior_sha_st, 2) ? N : 0 )));
            prior_sha_st_cor_beta_1 = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>((logical_eq(form_prior_sha_st, 2) ? N : 0 ), (logical_eq(form_prior_sha_st, 2) ? N : 0 ));
            vals_r__ = context__.vals_r("prior_sha_st_cor_beta_1");
            pos__ = 0;
            size_t prior_sha_st_cor_beta_1_j_2_max__ = (logical_eq(form_prior_sha_st, 2) ? N : 0 );
            size_t prior_sha_st_cor_beta_1_j_1_max__ = (logical_eq(form_prior_sha_st, 2) ? N : 0 );
            for (size_t j_2__ = 0; j_2__ < prior_sha_st_cor_beta_1_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < prior_sha_st_cor_beta_1_j_1_max__; ++j_1__) {
                    prior_sha_st_cor_beta_1(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 123;
            validate_non_negative_index("prior_sha_st_cor_beta_2", "(logical_eq(form_prior_sha_st, 2) ? N : 0 )", (logical_eq(form_prior_sha_st, 2) ? N : 0 ));
            validate_non_negative_index("prior_sha_st_cor_beta_2", "(logical_eq(form_prior_sha_st, 2) ? N : 0 )", (logical_eq(form_prior_sha_st, 2) ? N : 0 ));
            context__.validate_dims("data initialization", "prior_sha_st_cor_beta_2", "matrix_d", context__.to_vec((logical_eq(form_prior_sha_st, 2) ? N : 0 ),(logical_eq(form_prior_sha_st, 2) ? N : 0 )));
            prior_sha_st_cor_beta_2 = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>((logical_eq(form_prior_sha_st, 2) ? N : 0 ), (logical_eq(form_prior_sha_st, 2) ? N : 0 ));
            vals_r__ = context__.vals_r("prior_sha_st_cor_beta_2");
            pos__ = 0;
            size_t prior_sha_st_cor_beta_2_j_2_max__ = (logical_eq(form_prior_sha_st, 2) ? N : 0 );
            size_t prior_sha_st_cor_beta_2_j_1_max__ = (logical_eq(form_prior_sha_st, 2) ? N : 0 );
            for (size_t j_2__ = 0; j_2__ < prior_sha_st_cor_beta_2_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < prior_sha_st_cor_beta_2_j_1_max__; ++j_1__) {
                    prior_sha_st_cor_beta_2(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 125;
            context__.validate_dims("data initialization", "prior_sha_st_ar_alpha", "double", context__.to_vec());
            prior_sha_st_ar_alpha = double(0);
            vals_r__ = context__.vals_r("prior_sha_st_ar_alpha");
            pos__ = 0;
            prior_sha_st_ar_alpha = vals_r__[pos__++];
            check_greater_or_equal(function__, "prior_sha_st_ar_alpha", prior_sha_st_ar_alpha, 0);
            current_statement_begin__ = 126;
            context__.validate_dims("data initialization", "prior_sha_st_ar_beta", "double", context__.to_vec());
            prior_sha_st_ar_beta = double(0);
            vals_r__ = context__.vals_r("prior_sha_st_ar_beta");
            pos__ = 0;
            prior_sha_st_ar_beta = vals_r__[pos__++];
            check_greater_or_equal(function__, "prior_sha_st_ar_beta", prior_sha_st_ar_beta, 0);
            current_statement_begin__ = 129;
            validate_non_negative_index("prior_sha_lt_sd", "N", N);
            context__.validate_dims("data initialization", "prior_sha_lt_sd", "vector_d", context__.to_vec(N));
            prior_sha_lt_sd = Eigen::Matrix<double, Eigen::Dynamic, 1>(N);
            vals_r__ = context__.vals_r("prior_sha_lt_sd");
            pos__ = 0;
            size_t prior_sha_lt_sd_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < prior_sha_lt_sd_j_1_max__; ++j_1__) {
                prior_sha_lt_sd(j_1__) = vals_r__[pos__++];
            }
            check_greater_or_equal(function__, "prior_sha_lt_sd", prior_sha_lt_sd, 0);
            current_statement_begin__ = 132;
            validate_non_negative_index("prior_y_init_mean", "N", N);
            context__.validate_dims("data initialization", "prior_y_init_mean", "vector_d", context__.to_vec(N));
            prior_y_init_mean = Eigen::Matrix<double, Eigen::Dynamic, 1>(N);
            vals_r__ = context__.vals_r("prior_y_init_mean");
            pos__ = 0;
            size_t prior_y_init_mean_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < prior_y_init_mean_j_1_max__; ++j_1__) {
                prior_y_init_mean(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 133;
            validate_non_negative_index("prior_y_init_var", "N", N);
            context__.validate_dims("data initialization", "prior_y_init_var", "vector_d", context__.to_vec(N));
            prior_y_init_var = Eigen::Matrix<double, Eigen::Dynamic, 1>(N);
            vals_r__ = context__.vals_r("prior_y_init_var");
            pos__ = 0;
            size_t prior_y_init_var_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < prior_y_init_var_j_1_max__; ++j_1__) {
                prior_y_init_var(j_1__) = vals_r__[pos__++];
            }
            check_greater_or_equal(function__, "prior_y_init_var", prior_y_init_var, 0);
            current_statement_begin__ = 134;
            context__.validate_dims("data initialization", "prior_sigma_t_inv_wish_nu", "double", context__.to_vec());
            prior_sigma_t_inv_wish_nu = double(0);
            vals_r__ = context__.vals_r("prior_sigma_t_inv_wish_nu");
            pos__ = 0;
            prior_sigma_t_inv_wish_nu = vals_r__[pos__++];
            check_greater_or_equal(function__, "prior_sigma_t_inv_wish_nu", prior_sigma_t_inv_wish_nu, (N - 1));
            current_statement_begin__ = 135;
            validate_non_negative_index("prior_sigma_t_inv_wish_sigma", "N", N);
            validate_non_negative_index("prior_sigma_t_inv_wish_sigma", "N", N);
            context__.validate_dims("data initialization", "prior_sigma_t_inv_wish_sigma", "matrix_d", context__.to_vec(N,N));
            prior_sigma_t_inv_wish_sigma = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(N, N);
            vals_r__ = context__.vals_r("prior_sigma_t_inv_wish_sigma");
            pos__ = 0;
            size_t prior_sigma_t_inv_wish_sigma_j_2_max__ = N;
            size_t prior_sigma_t_inv_wish_sigma_j_1_max__ = N;
            for (size_t j_2__ = 0; j_2__ < prior_sigma_t_inv_wish_sigma_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < prior_sigma_t_inv_wish_sigma_j_1_max__; ++j_1__) {
                    prior_sigma_t_inv_wish_sigma(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            // initialize transformed data variables
            // execute transformed data statements
            // validate transformed data
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 144;
            validate_non_negative_index("ind_st_ar_param", "N", N);
            validate_non_negative_index("ind_st_ar_param", "M", M);
            num_params_r__ += (N * M);
            current_statement_begin__ = 145;
            validate_non_negative_index("ind_st_var", "N", N);
            validate_non_negative_index("ind_st_var", "M", M);
            num_params_r__ += (N * M);
            current_statement_begin__ = 146;
            validate_non_negative_index("ind_st_cor", "N", N);
            validate_non_negative_index("ind_st_cor", "N", N);
            validate_non_negative_index("ind_st_cor", "M", M);
            num_params_r__ += (((N * (N - 1)) / 2) * M);
            current_statement_begin__ = 147;
            validate_non_negative_index("ind_lt_raw", "N", N);
            validate_non_negative_index("ind_lt_raw", "M", M);
            num_params_r__ += (N * M);
            current_statement_begin__ = 148;
            validate_non_negative_index("ind_lt_var", "N", N);
            num_params_r__ += N;
            current_statement_begin__ = 149;
            validate_non_negative_index("ind_lt_cor", "N", N);
            validate_non_negative_index("ind_lt_cor", "N", N);
            num_params_r__ += ((N * (N - 1)) / 2);
            current_statement_begin__ = 151;
            validate_non_negative_index("sha_st_ar_param", "N", N);
            num_params_r__ += N;
            current_statement_begin__ = 152;
            validate_non_negative_index("sha_st_var", "N", N);
            num_params_r__ += N;
            current_statement_begin__ = 153;
            validate_non_negative_index("sha_st_cor", "N", N);
            validate_non_negative_index("sha_st_cor", "N", N);
            num_params_r__ += ((N * (N - 1)) / 2);
            current_statement_begin__ = 154;
            validate_non_negative_index("sha_lt_raw", "N", N);
            num_params_r__ += N;
            current_statement_begin__ = 159;
            validate_non_negative_index("SIGMA_t", "N", N);
            validate_non_negative_index("SIGMA_t", "N", N);
            num_params_r__ += (N + ((N * (N - 1)) / 2));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_ensemble_prior() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 144;
        if (!(context__.contains_r("ind_st_ar_param")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable ind_st_ar_param missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("ind_st_ar_param");
        pos__ = 0U;
        validate_non_negative_index("ind_st_ar_param", "N", N);
        validate_non_negative_index("ind_st_ar_param", "M", M);
        context__.validate_dims("parameter initialization", "ind_st_ar_param", "vector_d", context__.to_vec(M,N));
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > ind_st_ar_param(M, Eigen::Matrix<double, Eigen::Dynamic, 1>(N));
        size_t ind_st_ar_param_j_1_max__ = N;
        size_t ind_st_ar_param_k_0_max__ = M;
        for (size_t j_1__ = 0; j_1__ < ind_st_ar_param_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < ind_st_ar_param_k_0_max__; ++k_0__) {
                ind_st_ar_param[k_0__](j_1__) = vals_r__[pos__++];
            }
        }
        size_t ind_st_ar_param_i_0_max__ = M;
        for (size_t i_0__ = 0; i_0__ < ind_st_ar_param_i_0_max__; ++i_0__) {
            try {
                writer__.vector_lub_unconstrain(-(1), 1, ind_st_ar_param[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable ind_st_ar_param: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 145;
        if (!(context__.contains_r("ind_st_var")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable ind_st_var missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("ind_st_var");
        pos__ = 0U;
        validate_non_negative_index("ind_st_var", "N", N);
        validate_non_negative_index("ind_st_var", "M", M);
        context__.validate_dims("parameter initialization", "ind_st_var", "vector_d", context__.to_vec(M,N));
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > ind_st_var(M, Eigen::Matrix<double, Eigen::Dynamic, 1>(N));
        size_t ind_st_var_j_1_max__ = N;
        size_t ind_st_var_k_0_max__ = M;
        for (size_t j_1__ = 0; j_1__ < ind_st_var_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < ind_st_var_k_0_max__; ++k_0__) {
                ind_st_var[k_0__](j_1__) = vals_r__[pos__++];
            }
        }
        size_t ind_st_var_i_0_max__ = M;
        for (size_t i_0__ = 0; i_0__ < ind_st_var_i_0_max__; ++i_0__) {
            try {
                writer__.vector_lb_unconstrain(0, ind_st_var[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable ind_st_var: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 146;
        if (!(context__.contains_r("ind_st_cor")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable ind_st_cor missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("ind_st_cor");
        pos__ = 0U;
        validate_non_negative_index("ind_st_cor", "N", N);
        validate_non_negative_index("ind_st_cor", "N", N);
        validate_non_negative_index("ind_st_cor", "M", M);
        context__.validate_dims("parameter initialization", "ind_st_cor", "matrix_d", context__.to_vec(M,N,N));
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> > ind_st_cor(M, Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(N, N));
        size_t ind_st_cor_j_2_max__ = N;
        size_t ind_st_cor_j_1_max__ = N;
        size_t ind_st_cor_k_0_max__ = M;
        for (size_t j_2__ = 0; j_2__ < ind_st_cor_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < ind_st_cor_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < ind_st_cor_k_0_max__; ++k_0__) {
                    ind_st_cor[k_0__](j_1__, j_2__) = vals_r__[pos__++];
                }
            }
        }
        size_t ind_st_cor_i_0_max__ = M;
        for (size_t i_0__ = 0; i_0__ < ind_st_cor_i_0_max__; ++i_0__) {
            try {
                writer__.corr_matrix_unconstrain(ind_st_cor[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable ind_st_cor: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 147;
        if (!(context__.contains_r("ind_lt_raw")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable ind_lt_raw missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("ind_lt_raw");
        pos__ = 0U;
        validate_non_negative_index("ind_lt_raw", "N", N);
        validate_non_negative_index("ind_lt_raw", "M", M);
        context__.validate_dims("parameter initialization", "ind_lt_raw", "vector_d", context__.to_vec(M,N));
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > ind_lt_raw(M, Eigen::Matrix<double, Eigen::Dynamic, 1>(N));
        size_t ind_lt_raw_j_1_max__ = N;
        size_t ind_lt_raw_k_0_max__ = M;
        for (size_t j_1__ = 0; j_1__ < ind_lt_raw_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < ind_lt_raw_k_0_max__; ++k_0__) {
                ind_lt_raw[k_0__](j_1__) = vals_r__[pos__++];
            }
        }
        size_t ind_lt_raw_i_0_max__ = M;
        for (size_t i_0__ = 0; i_0__ < ind_lt_raw_i_0_max__; ++i_0__) {
            try {
                writer__.vector_unconstrain(ind_lt_raw[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable ind_lt_raw: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 148;
        if (!(context__.contains_r("ind_lt_var")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable ind_lt_var missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("ind_lt_var");
        pos__ = 0U;
        validate_non_negative_index("ind_lt_var", "N", N);
        context__.validate_dims("parameter initialization", "ind_lt_var", "vector_d", context__.to_vec(N));
        Eigen::Matrix<double, Eigen::Dynamic, 1> ind_lt_var(N);
        size_t ind_lt_var_j_1_max__ = N;
        for (size_t j_1__ = 0; j_1__ < ind_lt_var_j_1_max__; ++j_1__) {
            ind_lt_var(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, ind_lt_var);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable ind_lt_var: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 149;
        if (!(context__.contains_r("ind_lt_cor")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable ind_lt_cor missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("ind_lt_cor");
        pos__ = 0U;
        validate_non_negative_index("ind_lt_cor", "N", N);
        validate_non_negative_index("ind_lt_cor", "N", N);
        context__.validate_dims("parameter initialization", "ind_lt_cor", "matrix_d", context__.to_vec(N,N));
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> ind_lt_cor(N, N);
        size_t ind_lt_cor_j_2_max__ = N;
        size_t ind_lt_cor_j_1_max__ = N;
        for (size_t j_2__ = 0; j_2__ < ind_lt_cor_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < ind_lt_cor_j_1_max__; ++j_1__) {
                ind_lt_cor(j_1__, j_2__) = vals_r__[pos__++];
            }
        }
        try {
            writer__.corr_matrix_unconstrain(ind_lt_cor);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable ind_lt_cor: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 151;
        if (!(context__.contains_r("sha_st_ar_param")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable sha_st_ar_param missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("sha_st_ar_param");
        pos__ = 0U;
        validate_non_negative_index("sha_st_ar_param", "N", N);
        context__.validate_dims("parameter initialization", "sha_st_ar_param", "vector_d", context__.to_vec(N));
        Eigen::Matrix<double, Eigen::Dynamic, 1> sha_st_ar_param(N);
        size_t sha_st_ar_param_j_1_max__ = N;
        for (size_t j_1__ = 0; j_1__ < sha_st_ar_param_j_1_max__; ++j_1__) {
            sha_st_ar_param(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lub_unconstrain(-(1), 1, sha_st_ar_param);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable sha_st_ar_param: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 152;
        if (!(context__.contains_r("sha_st_var")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable sha_st_var missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("sha_st_var");
        pos__ = 0U;
        validate_non_negative_index("sha_st_var", "N", N);
        context__.validate_dims("parameter initialization", "sha_st_var", "vector_d", context__.to_vec(N));
        Eigen::Matrix<double, Eigen::Dynamic, 1> sha_st_var(N);
        size_t sha_st_var_j_1_max__ = N;
        for (size_t j_1__ = 0; j_1__ < sha_st_var_j_1_max__; ++j_1__) {
            sha_st_var(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, sha_st_var);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable sha_st_var: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 153;
        if (!(context__.contains_r("sha_st_cor")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable sha_st_cor missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("sha_st_cor");
        pos__ = 0U;
        validate_non_negative_index("sha_st_cor", "N", N);
        validate_non_negative_index("sha_st_cor", "N", N);
        context__.validate_dims("parameter initialization", "sha_st_cor", "matrix_d", context__.to_vec(N,N));
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> sha_st_cor(N, N);
        size_t sha_st_cor_j_2_max__ = N;
        size_t sha_st_cor_j_1_max__ = N;
        for (size_t j_2__ = 0; j_2__ < sha_st_cor_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < sha_st_cor_j_1_max__; ++j_1__) {
                sha_st_cor(j_1__, j_2__) = vals_r__[pos__++];
            }
        }
        try {
            writer__.corr_matrix_unconstrain(sha_st_cor);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable sha_st_cor: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 154;
        if (!(context__.contains_r("sha_lt_raw")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable sha_lt_raw missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("sha_lt_raw");
        pos__ = 0U;
        validate_non_negative_index("sha_lt_raw", "N", N);
        context__.validate_dims("parameter initialization", "sha_lt_raw", "vector_d", context__.to_vec(N));
        Eigen::Matrix<double, Eigen::Dynamic, 1> sha_lt_raw(N);
        size_t sha_lt_raw_j_1_max__ = N;
        for (size_t j_1__ = 0; j_1__ < sha_lt_raw_j_1_max__; ++j_1__) {
            sha_lt_raw(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(sha_lt_raw);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable sha_lt_raw: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 159;
        if (!(context__.contains_r("SIGMA_t")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable SIGMA_t missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("SIGMA_t");
        pos__ = 0U;
        validate_non_negative_index("SIGMA_t", "N", N);
        validate_non_negative_index("SIGMA_t", "N", N);
        context__.validate_dims("parameter initialization", "SIGMA_t", "matrix_d", context__.to_vec(N,N));
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> SIGMA_t(N, N);
        size_t SIGMA_t_j_2_max__ = N;
        size_t SIGMA_t_j_1_max__ = N;
        for (size_t j_2__ = 0; j_2__ < SIGMA_t_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < SIGMA_t_j_1_max__; ++j_1__) {
                SIGMA_t(j_1__, j_2__) = vals_r__[pos__++];
            }
        }
        try {
            writer__.cov_matrix_unconstrain(SIGMA_t);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable SIGMA_t: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 144;
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> > ind_st_ar_param;
            size_t ind_st_ar_param_d_0_max__ = M;
            ind_st_ar_param.reserve(ind_st_ar_param_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < ind_st_ar_param_d_0_max__; ++d_0__) {
                if (jacobian__)
                    ind_st_ar_param.push_back(in__.vector_lub_constrain(-(1), 1, N, lp__));
                else
                    ind_st_ar_param.push_back(in__.vector_lub_constrain(-(1), 1, N));
            }
            current_statement_begin__ = 145;
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> > ind_st_var;
            size_t ind_st_var_d_0_max__ = M;
            ind_st_var.reserve(ind_st_var_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < ind_st_var_d_0_max__; ++d_0__) {
                if (jacobian__)
                    ind_st_var.push_back(in__.vector_lb_constrain(0, N, lp__));
                else
                    ind_st_var.push_back(in__.vector_lb_constrain(0, N));
            }
            current_statement_begin__ = 146;
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> > ind_st_cor;
            size_t ind_st_cor_d_0_max__ = M;
            ind_st_cor.reserve(ind_st_cor_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < ind_st_cor_d_0_max__; ++d_0__) {
                if (jacobian__)
                    ind_st_cor.push_back(in__.corr_matrix_constrain(N, lp__));
                else
                    ind_st_cor.push_back(in__.corr_matrix_constrain(N));
            }
            current_statement_begin__ = 147;
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> > ind_lt_raw;
            size_t ind_lt_raw_d_0_max__ = M;
            ind_lt_raw.reserve(ind_lt_raw_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < ind_lt_raw_d_0_max__; ++d_0__) {
                if (jacobian__)
                    ind_lt_raw.push_back(in__.vector_constrain(N, lp__));
                else
                    ind_lt_raw.push_back(in__.vector_constrain(N));
            }
            current_statement_begin__ = 148;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> ind_lt_var;
            (void) ind_lt_var;  // dummy to suppress unused var warning
            if (jacobian__)
                ind_lt_var = in__.vector_lb_constrain(0, N, lp__);
            else
                ind_lt_var = in__.vector_lb_constrain(0, N);
            current_statement_begin__ = 149;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> ind_lt_cor;
            (void) ind_lt_cor;  // dummy to suppress unused var warning
            if (jacobian__)
                ind_lt_cor = in__.corr_matrix_constrain(N, lp__);
            else
                ind_lt_cor = in__.corr_matrix_constrain(N);
            current_statement_begin__ = 151;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> sha_st_ar_param;
            (void) sha_st_ar_param;  // dummy to suppress unused var warning
            if (jacobian__)
                sha_st_ar_param = in__.vector_lub_constrain(-(1), 1, N, lp__);
            else
                sha_st_ar_param = in__.vector_lub_constrain(-(1), 1, N);
            current_statement_begin__ = 152;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> sha_st_var;
            (void) sha_st_var;  // dummy to suppress unused var warning
            if (jacobian__)
                sha_st_var = in__.vector_lb_constrain(0, N, lp__);
            else
                sha_st_var = in__.vector_lb_constrain(0, N);
            current_statement_begin__ = 153;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> sha_st_cor;
            (void) sha_st_cor;  // dummy to suppress unused var warning
            if (jacobian__)
                sha_st_cor = in__.corr_matrix_constrain(N, lp__);
            else
                sha_st_cor = in__.corr_matrix_constrain(N);
            current_statement_begin__ = 154;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> sha_lt_raw;
            (void) sha_lt_raw;  // dummy to suppress unused var warning
            if (jacobian__)
                sha_lt_raw = in__.vector_constrain(N, lp__);
            else
                sha_lt_raw = in__.vector_constrain(N);
            current_statement_begin__ = 159;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> SIGMA_t;
            (void) SIGMA_t;  // dummy to suppress unused var warning
            if (jacobian__)
                SIGMA_t = in__.cov_matrix_constrain(N, lp__);
            else
                SIGMA_t = in__.cov_matrix_constrain(N);
            // transformed parameters
            current_statement_begin__ = 163;
            validate_non_negative_index("SIGMA_x", "N", N);
            validate_non_negative_index("SIGMA_x", "N", N);
            validate_non_negative_index("SIGMA_x", "M", M);
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> > SIGMA_x(M, Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic>(N, N));
            stan::math::initialize(SIGMA_x, DUMMY_VAR__);
            stan::math::fill(SIGMA_x, DUMMY_VAR__);
            current_statement_begin__ = 164;
            validate_non_negative_index("ind_st_sd", "N", N);
            validate_non_negative_index("ind_st_sd", "M", M);
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> > ind_st_sd(M, Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1>(N));
            stan::math::initialize(ind_st_sd, DUMMY_VAR__);
            stan::math::fill(ind_st_sd, DUMMY_VAR__);
            current_statement_begin__ = 165;
            validate_non_negative_index("sha_lt", "N", N);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> sha_lt(N);
            stan::math::initialize(sha_lt, DUMMY_VAR__);
            stan::math::fill(sha_lt, DUMMY_VAR__);
            stan::math::assign(sha_lt,elt_multiply(prior_sha_lt_sd, sha_lt_raw));
            current_statement_begin__ = 166;
            validate_non_negative_index("ind_lt", "N", N);
            validate_non_negative_index("ind_lt", "M", M);
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> > ind_lt(M, Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1>(N));
            stan::math::initialize(ind_lt, DUMMY_VAR__);
            stan::math::fill(ind_lt, DUMMY_VAR__);
            current_statement_begin__ = 167;
            validate_non_negative_index("ind_lt_sd", "N", N);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> ind_lt_sd(N);
            stan::math::initialize(ind_lt_sd, DUMMY_VAR__);
            stan::math::fill(ind_lt_sd, DUMMY_VAR__);
            stan::math::assign(ind_lt_sd,stan::math::sqrt(ind_lt_var));
            current_statement_begin__ = 168;
            validate_non_negative_index("ind_lt_covar", "N", N);
            validate_non_negative_index("ind_lt_covar", "N", N);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> ind_lt_covar(N, N);
            stan::math::initialize(ind_lt_covar, DUMMY_VAR__);
            stan::math::fill(ind_lt_covar, DUMMY_VAR__);
            stan::math::assign(ind_lt_covar,diag_post_multiply(diag_pre_multiply(ind_lt_sd, ind_lt_cor), ind_lt_sd));
            current_statement_begin__ = 169;
            validate_non_negative_index("ind_lt_cov_cholesky", "N", N);
            validate_non_negative_index("ind_lt_cov_cholesky", "N", N);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> ind_lt_cov_cholesky(N, N);
            stan::math::initialize(ind_lt_cov_cholesky, DUMMY_VAR__);
            stan::math::fill(ind_lt_cov_cholesky, DUMMY_VAR__);
            stan::math::assign(ind_lt_cov_cholesky,cholesky_decompose(ind_lt_covar));
            current_statement_begin__ = 172;
            validate_non_negative_index("x_hat", "((M + 2) * N)", ((M + 2) * N));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> x_hat(((M + 2) * N));
            stan::math::initialize(x_hat, DUMMY_VAR__);
            stan::math::fill(x_hat, DUMMY_VAR__);
            stan::math::assign(x_hat,append_row(prior_y_init_mean, rep_vector(0.0, (N * (M + 1)))));
            current_statement_begin__ = 173;
            validate_non_negative_index("SIGMA_init", "((M + 2) * N)", ((M + 2) * N));
            validate_non_negative_index("SIGMA_init", "((M + 2) * N)", ((M + 2) * N));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> SIGMA_init(((M + 2) * N), ((M + 2) * N));
            stan::math::initialize(SIGMA_init, DUMMY_VAR__);
            stan::math::fill(SIGMA_init, DUMMY_VAR__);
            stan::math::assign(SIGMA_init,rep_matrix(0, ((M + 2) * N), ((M + 2) * N)));
            current_statement_begin__ = 175;
            validate_non_negative_index("sha_st_sd", "N", N);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> sha_st_sd(N);
            stan::math::initialize(sha_st_sd, DUMMY_VAR__);
            stan::math::fill(sha_st_sd, DUMMY_VAR__);
            stan::math::assign(sha_st_sd,stan::math::sqrt(sha_st_var));
            current_statement_begin__ = 176;
            validate_non_negative_index("SIGMA_mu", "N", N);
            validate_non_negative_index("SIGMA_mu", "N", N);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> SIGMA_mu(N, N);
            stan::math::initialize(SIGMA_mu, DUMMY_VAR__);
            stan::math::fill(SIGMA_mu, DUMMY_VAR__);
            stan::math::assign(SIGMA_mu,diag_post_multiply(diag_pre_multiply(sha_st_sd, sha_st_cor), sha_st_sd));
            current_statement_begin__ = 185;
            validate_non_negative_index("SIGMA", "((M + 2) * N)", ((M + 2) * N));
            validate_non_negative_index("SIGMA", "((M + 2) * N)", ((M + 2) * N));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> SIGMA(((M + 2) * N), ((M + 2) * N));
            stan::math::initialize(SIGMA, DUMMY_VAR__);
            stan::math::fill(SIGMA, DUMMY_VAR__);
            stan::math::assign(SIGMA,rep_matrix(0, ((M + 2) * N), ((M + 2) * N)));
            current_statement_begin__ = 186;
            validate_non_negative_index("lt_discrepancies", "((M + 2) * N)", ((M + 2) * N));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> lt_discrepancies(((M + 2) * N));
            stan::math::initialize(lt_discrepancies, DUMMY_VAR__);
            stan::math::fill(lt_discrepancies, DUMMY_VAR__);
            current_statement_begin__ = 187;
            validate_non_negative_index("AR_params", "((M + 2) * N)", ((M + 2) * N));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> AR_params(((M + 2) * N));
            stan::math::initialize(AR_params, DUMMY_VAR__);
            stan::math::fill(AR_params, DUMMY_VAR__);
            // transformed parameters block statements
            current_statement_begin__ = 190;
            stan::model::assign(SIGMA, 
                        stan::model::cons_list(stan::model::index_min_max(1, N), stan::model::cons_list(stan::model::index_min_max(1, N), stan::model::nil_index_list())), 
                        SIGMA_t, 
                        "assigning variable SIGMA");
            current_statement_begin__ = 191;
            stan::model::assign(SIGMA, 
                        stan::model::cons_list(stan::model::index_min_max((N + 1), (2 * N)), stan::model::cons_list(stan::model::index_min_max((N + 1), (2 * N)), stan::model::nil_index_list())), 
                        SIGMA_mu, 
                        "assigning variable SIGMA");
            current_statement_begin__ = 192;
            for (int i = 1; i <= M; ++i) {
                current_statement_begin__ = 193;
                stan::model::assign(ind_st_sd, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            stan::math::sqrt(get_base1(ind_st_var, i, "ind_st_var", 1)), 
                            "assigning variable ind_st_sd");
                current_statement_begin__ = 195;
                stan::model::assign(SIGMA_x, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            diag_post_multiply(diag_pre_multiply(get_base1(ind_st_sd, i, "ind_st_sd", 1), get_base1(ind_st_cor, i, "ind_st_cor", 1)), get_base1(ind_st_sd, i, "ind_st_sd", 1)), 
                            "assigning variable SIGMA_x");
                current_statement_begin__ = 196;
                stan::model::assign(SIGMA, 
                            stan::model::cons_list(stan::model::index_min_max((((i + 1) * N) + 1), ((i + 2) * N)), stan::model::cons_list(stan::model::index_min_max((((i + 1) * N) + 1), ((i + 2) * N)), stan::model::nil_index_list())), 
                            get_base1(SIGMA_x, i, "SIGMA_x", 1), 
                            "assigning variable SIGMA");
            }
            current_statement_begin__ = 200;
            stan::model::assign(SIGMA_init, 
                        stan::model::cons_list(stan::model::index_min_max(1, N), stan::model::cons_list(stan::model::index_min_max(1, N), stan::model::nil_index_list())), 
                        diag_matrix(prior_y_init_var), 
                        "assigning variable SIGMA_init");
            current_statement_begin__ = 201;
            stan::model::assign(SIGMA_init, 
                        stan::model::cons_list(stan::model::index_min_max((N + 1), (2 * N)), stan::model::cons_list(stan::model::index_min_max((N + 1), (2 * N)), stan::model::nil_index_list())), 
                        elt_divide(SIGMA_mu, subtract(1, multiply(sha_st_ar_param, transpose(sha_st_ar_param)))), 
                        "assigning variable SIGMA_init");
            current_statement_begin__ = 202;
            for (int i = 1; i <= M; ++i) {
                current_statement_begin__ = 203;
                stan::model::assign(SIGMA_init, 
                            stan::model::cons_list(stan::model::index_min_max((((i + 1) * N) + 1), ((i + 2) * N)), stan::model::cons_list(stan::model::index_min_max((((i + 1) * N) + 1), ((i + 2) * N)), stan::model::nil_index_list())), 
                            elt_divide(get_base1(SIGMA_x, i, "SIGMA_x", 1), subtract(1, multiply(get_base1(ind_st_ar_param, i, "ind_st_ar_param", 1), transpose(get_base1(ind_st_ar_param, i, "ind_st_ar_param", 1))))), 
                            "assigning variable SIGMA_init");
            }
            current_statement_begin__ = 208;
            stan::model::assign(lt_discrepancies, 
                        stan::model::cons_list(stan::model::index_min_max(1, (2 * N)), stan::model::nil_index_list()), 
                        append_row(rep_vector(0.0, N), sha_lt), 
                        "assigning variable lt_discrepancies");
            current_statement_begin__ = 209;
            stan::model::assign(AR_params, 
                        stan::model::cons_list(stan::model::index_min_max(1, (2 * N)), stan::model::nil_index_list()), 
                        append_row(rep_vector(1.0, N), sha_st_ar_param), 
                        "assigning variable AR_params");
            current_statement_begin__ = 210;
            for (int i = 1; i <= M; ++i) {
                current_statement_begin__ = 211;
                stan::model::assign(ind_lt, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            multiply(ind_lt_cov_cholesky, get_base1(ind_lt_raw, i, "ind_lt_raw", 1)), 
                            "assigning variable ind_lt");
                current_statement_begin__ = 212;
                stan::model::assign(lt_discrepancies, 
                            stan::model::cons_list(stan::model::index_min_max((((i + 1) * N) + 1), ((i + 2) * N)), stan::model::nil_index_list()), 
                            get_base1(ind_lt, i, "ind_lt", 1), 
                            "assigning variable lt_discrepancies");
                current_statement_begin__ = 213;
                stan::model::assign(AR_params, 
                            stan::model::cons_list(stan::model::index_min_max((((i + 1) * N) + 1), ((i + 2) * N)), stan::model::nil_index_list()), 
                            get_base1(ind_st_ar_param, i, "ind_st_ar_param", 1), 
                            "assigning variable AR_params");
            }
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 163;
            size_t SIGMA_x_k_0_max__ = M;
            size_t SIGMA_x_j_1_max__ = N;
            size_t SIGMA_x_j_2_max__ = N;
            for (size_t k_0__ = 0; k_0__ < SIGMA_x_k_0_max__; ++k_0__) {
                for (size_t j_1__ = 0; j_1__ < SIGMA_x_j_1_max__; ++j_1__) {
                    for (size_t j_2__ = 0; j_2__ < SIGMA_x_j_2_max__; ++j_2__) {
                        if (stan::math::is_uninitialized(SIGMA_x[k_0__](j_1__, j_2__))) {
                            std::stringstream msg__;
                            msg__ << "Undefined transformed parameter: SIGMA_x" << "[" << k_0__ << "]" << "(" << j_1__ << ", " << j_2__ << ")";
                            stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable SIGMA_x: ") + msg__.str()), current_statement_begin__, prog_reader__());
                        }
                    }
                }
            }
            current_statement_begin__ = 164;
            size_t ind_st_sd_k_0_max__ = M;
            size_t ind_st_sd_j_1_max__ = N;
            for (size_t k_0__ = 0; k_0__ < ind_st_sd_k_0_max__; ++k_0__) {
                for (size_t j_1__ = 0; j_1__ < ind_st_sd_j_1_max__; ++j_1__) {
                    if (stan::math::is_uninitialized(ind_st_sd[k_0__](j_1__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: ind_st_sd" << "[" << k_0__ << "]" << "(" << j_1__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable ind_st_sd: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 165;
            size_t sha_lt_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < sha_lt_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(sha_lt(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: sha_lt" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable sha_lt: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 166;
            size_t ind_lt_k_0_max__ = M;
            size_t ind_lt_j_1_max__ = N;
            for (size_t k_0__ = 0; k_0__ < ind_lt_k_0_max__; ++k_0__) {
                for (size_t j_1__ = 0; j_1__ < ind_lt_j_1_max__; ++j_1__) {
                    if (stan::math::is_uninitialized(ind_lt[k_0__](j_1__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: ind_lt" << "[" << k_0__ << "]" << "(" << j_1__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable ind_lt: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 167;
            size_t ind_lt_sd_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < ind_lt_sd_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(ind_lt_sd(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: ind_lt_sd" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable ind_lt_sd: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 168;
            size_t ind_lt_covar_j_1_max__ = N;
            size_t ind_lt_covar_j_2_max__ = N;
            for (size_t j_1__ = 0; j_1__ < ind_lt_covar_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < ind_lt_covar_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(ind_lt_covar(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: ind_lt_covar" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable ind_lt_covar: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 169;
            size_t ind_lt_cov_cholesky_j_1_max__ = N;
            size_t ind_lt_cov_cholesky_j_2_max__ = N;
            for (size_t j_1__ = 0; j_1__ < ind_lt_cov_cholesky_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < ind_lt_cov_cholesky_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(ind_lt_cov_cholesky(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: ind_lt_cov_cholesky" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable ind_lt_cov_cholesky: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 172;
            size_t x_hat_j_1_max__ = ((M + 2) * N);
            for (size_t j_1__ = 0; j_1__ < x_hat_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(x_hat(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: x_hat" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable x_hat: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 173;
            size_t SIGMA_init_j_1_max__ = ((M + 2) * N);
            size_t SIGMA_init_j_2_max__ = ((M + 2) * N);
            for (size_t j_1__ = 0; j_1__ < SIGMA_init_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < SIGMA_init_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(SIGMA_init(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: SIGMA_init" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable SIGMA_init: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 175;
            size_t sha_st_sd_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < sha_st_sd_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(sha_st_sd(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: sha_st_sd" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable sha_st_sd: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 176;
            size_t SIGMA_mu_j_1_max__ = N;
            size_t SIGMA_mu_j_2_max__ = N;
            for (size_t j_1__ = 0; j_1__ < SIGMA_mu_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < SIGMA_mu_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(SIGMA_mu(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: SIGMA_mu" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable SIGMA_mu: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 185;
            size_t SIGMA_j_1_max__ = ((M + 2) * N);
            size_t SIGMA_j_2_max__ = ((M + 2) * N);
            for (size_t j_1__ = 0; j_1__ < SIGMA_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < SIGMA_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(SIGMA(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: SIGMA" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable SIGMA: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 186;
            size_t lt_discrepancies_j_1_max__ = ((M + 2) * N);
            for (size_t j_1__ = 0; j_1__ < lt_discrepancies_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(lt_discrepancies(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: lt_discrepancies" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable lt_discrepancies: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 187;
            size_t AR_params_j_1_max__ = ((M + 2) * N);
            for (size_t j_1__ = 0; j_1__ < AR_params_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(AR_params(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: AR_params" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable AR_params: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            // model body
            current_statement_begin__ = 221;
            lp_accum__.add(inv_wishart_log<propto__>(SIGMA_t, prior_sigma_t_inv_wish_nu, prior_sigma_t_inv_wish_sigma));
            current_statement_begin__ = 225;
            lp_accum__.add(std_normal_log<propto__>(sha_lt_raw));
            current_statement_begin__ = 226;
            lp_accum__.add(gamma_log<propto__>(sha_st_var, prior_sha_st_var_a, prior_sha_st_var_b));
            current_statement_begin__ = 228;
            lp_accum__.add(beta_log(divide(add(sha_st_ar_param, 1), 2), prior_sha_st_ar_alpha, prior_sha_st_ar_beta));
            current_statement_begin__ = 231;
            if (as_bool(logical_eq(form_prior_sha_st, 0))) {
                current_statement_begin__ = 232;
                lp_accum__.add(lkj_corr_log<propto__>(sha_st_cor, get_base1(prior_sha_st_cor_lkj, 1, "prior_sha_st_cor_lkj", 1)));
            } else if (as_bool(logical_eq(form_prior_sha_st, 1))) {
                current_statement_begin__ = 234;
                lp_accum__.add(inv_wishart_log<propto__>(sha_st_cor, get_base1(prior_sha_st_cor_wish_nu, 1, "prior_sha_st_cor_wish_nu", 1), prior_sha_st_cor_wish_sigma));
            } else {
                current_statement_begin__ = 236;
                lp_accum__.add(priors_cor_beta(sha_st_cor, N, prior_sha_st_cor_beta_1, prior_sha_st_cor_beta_2, pstream__));
            }
            current_statement_begin__ = 243;
            lp_accum__.add(gamma_log<propto__>(ind_lt_var, prior_ind_lt_var_a, prior_ind_lt_var_b));
            current_statement_begin__ = 245;
            if (as_bool(logical_eq(form_prior_ind_lt, 0))) {
                current_statement_begin__ = 246;
                lp_accum__.add(lkj_corr_log<propto__>(ind_lt_cor, get_base1(prior_ind_lt_cor_lkj, 1, "prior_ind_lt_cor_lkj", 1)));
            } else if (as_bool(logical_eq(form_prior_ind_lt, 1))) {
                current_statement_begin__ = 248;
                lp_accum__.add(inv_wishart_log<propto__>(ind_lt_cor, get_base1(prior_ind_lt_cor_wish_nu, 1, "prior_ind_lt_cor_wish_nu", 1), prior_ind_lt_cor_wish_sigma));
            } else {
                current_statement_begin__ = 250;
                lp_accum__.add(priors_cor_beta(ind_lt_cor, N, prior_ind_lt_cor_beta_1, prior_ind_lt_cor_beta_2, pstream__));
            }
            current_statement_begin__ = 254;
            for (int i = 1; i <= M; ++i) {
                current_statement_begin__ = 256;
                lp_accum__.add(beta_log(divide(add(get_base1(ind_st_ar_param, i, "ind_st_ar_param", 1), 1), 2), prior_ind_st_ar_alpha, prior_ind_st_ar_beta));
                current_statement_begin__ = 258;
                lp_accum__.add(gamma_log<propto__>(get_base1(ind_st_var, i, "ind_st_var", 1), prior_ind_st_var_a, prior_ind_st_var_b));
                current_statement_begin__ = 259;
                lp_accum__.add(std_normal_log<propto__>(get_base1(ind_lt_raw, i, "ind_lt_raw", 1)));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("ind_st_ar_param");
        names__.push_back("ind_st_var");
        names__.push_back("ind_st_cor");
        names__.push_back("ind_lt_raw");
        names__.push_back("ind_lt_var");
        names__.push_back("ind_lt_cor");
        names__.push_back("sha_st_ar_param");
        names__.push_back("sha_st_var");
        names__.push_back("sha_st_cor");
        names__.push_back("sha_lt_raw");
        names__.push_back("SIGMA_t");
        names__.push_back("SIGMA_x");
        names__.push_back("ind_st_sd");
        names__.push_back("sha_lt");
        names__.push_back("ind_lt");
        names__.push_back("ind_lt_sd");
        names__.push_back("ind_lt_covar");
        names__.push_back("ind_lt_cov_cholesky");
        names__.push_back("x_hat");
        names__.push_back("SIGMA_init");
        names__.push_back("sha_st_sd");
        names__.push_back("SIGMA_mu");
        names__.push_back("SIGMA");
        names__.push_back("lt_discrepancies");
        names__.push_back("AR_params");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(M);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(M);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(M);
        dims__.push_back(N);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(M);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(M);
        dims__.push_back(N);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(M);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(M);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(((M + 2) * N));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(((M + 2) * N));
        dims__.push_back(((M + 2) * N));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(((M + 2) * N));
        dims__.push_back(((M + 2) * N));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(((M + 2) * N));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(((M + 2) * N));
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_ensemble_prior_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > ind_st_ar_param;
        size_t ind_st_ar_param_d_0_max__ = M;
        ind_st_ar_param.reserve(ind_st_ar_param_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < ind_st_ar_param_d_0_max__; ++d_0__) {
            ind_st_ar_param.push_back(in__.vector_lub_constrain(-(1), 1, N));
        }
        size_t ind_st_ar_param_j_1_max__ = N;
        size_t ind_st_ar_param_k_0_max__ = M;
        for (size_t j_1__ = 0; j_1__ < ind_st_ar_param_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < ind_st_ar_param_k_0_max__; ++k_0__) {
                vars__.push_back(ind_st_ar_param[k_0__](j_1__));
            }
        }
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > ind_st_var;
        size_t ind_st_var_d_0_max__ = M;
        ind_st_var.reserve(ind_st_var_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < ind_st_var_d_0_max__; ++d_0__) {
            ind_st_var.push_back(in__.vector_lb_constrain(0, N));
        }
        size_t ind_st_var_j_1_max__ = N;
        size_t ind_st_var_k_0_max__ = M;
        for (size_t j_1__ = 0; j_1__ < ind_st_var_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < ind_st_var_k_0_max__; ++k_0__) {
                vars__.push_back(ind_st_var[k_0__](j_1__));
            }
        }
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> > ind_st_cor;
        size_t ind_st_cor_d_0_max__ = M;
        ind_st_cor.reserve(ind_st_cor_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < ind_st_cor_d_0_max__; ++d_0__) {
            ind_st_cor.push_back(in__.corr_matrix_constrain(N));
        }
        size_t ind_st_cor_j_2_max__ = N;
        size_t ind_st_cor_j_1_max__ = N;
        size_t ind_st_cor_k_0_max__ = M;
        for (size_t j_2__ = 0; j_2__ < ind_st_cor_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < ind_st_cor_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < ind_st_cor_k_0_max__; ++k_0__) {
                    vars__.push_back(ind_st_cor[k_0__](j_1__, j_2__));
                }
            }
        }
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > ind_lt_raw;
        size_t ind_lt_raw_d_0_max__ = M;
        ind_lt_raw.reserve(ind_lt_raw_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < ind_lt_raw_d_0_max__; ++d_0__) {
            ind_lt_raw.push_back(in__.vector_constrain(N));
        }
        size_t ind_lt_raw_j_1_max__ = N;
        size_t ind_lt_raw_k_0_max__ = M;
        for (size_t j_1__ = 0; j_1__ < ind_lt_raw_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < ind_lt_raw_k_0_max__; ++k_0__) {
                vars__.push_back(ind_lt_raw[k_0__](j_1__));
            }
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> ind_lt_var = in__.vector_lb_constrain(0, N);
        size_t ind_lt_var_j_1_max__ = N;
        for (size_t j_1__ = 0; j_1__ < ind_lt_var_j_1_max__; ++j_1__) {
            vars__.push_back(ind_lt_var(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> ind_lt_cor = in__.corr_matrix_constrain(N);
        size_t ind_lt_cor_j_2_max__ = N;
        size_t ind_lt_cor_j_1_max__ = N;
        for (size_t j_2__ = 0; j_2__ < ind_lt_cor_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < ind_lt_cor_j_1_max__; ++j_1__) {
                vars__.push_back(ind_lt_cor(j_1__, j_2__));
            }
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> sha_st_ar_param = in__.vector_lub_constrain(-(1), 1, N);
        size_t sha_st_ar_param_j_1_max__ = N;
        for (size_t j_1__ = 0; j_1__ < sha_st_ar_param_j_1_max__; ++j_1__) {
            vars__.push_back(sha_st_ar_param(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> sha_st_var = in__.vector_lb_constrain(0, N);
        size_t sha_st_var_j_1_max__ = N;
        for (size_t j_1__ = 0; j_1__ < sha_st_var_j_1_max__; ++j_1__) {
            vars__.push_back(sha_st_var(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> sha_st_cor = in__.corr_matrix_constrain(N);
        size_t sha_st_cor_j_2_max__ = N;
        size_t sha_st_cor_j_1_max__ = N;
        for (size_t j_2__ = 0; j_2__ < sha_st_cor_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < sha_st_cor_j_1_max__; ++j_1__) {
                vars__.push_back(sha_st_cor(j_1__, j_2__));
            }
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> sha_lt_raw = in__.vector_constrain(N);
        size_t sha_lt_raw_j_1_max__ = N;
        for (size_t j_1__ = 0; j_1__ < sha_lt_raw_j_1_max__; ++j_1__) {
            vars__.push_back(sha_lt_raw(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> SIGMA_t = in__.cov_matrix_constrain(N);
        size_t SIGMA_t_j_2_max__ = N;
        size_t SIGMA_t_j_1_max__ = N;
        for (size_t j_2__ = 0; j_2__ < SIGMA_t_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < SIGMA_t_j_1_max__; ++j_1__) {
                vars__.push_back(SIGMA_t(j_1__, j_2__));
            }
        }
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            // declare and define transformed parameters
            current_statement_begin__ = 163;
            validate_non_negative_index("SIGMA_x", "N", N);
            validate_non_negative_index("SIGMA_x", "N", N);
            validate_non_negative_index("SIGMA_x", "M", M);
            std::vector<Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> > SIGMA_x(M, Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(N, N));
            stan::math::initialize(SIGMA_x, DUMMY_VAR__);
            stan::math::fill(SIGMA_x, DUMMY_VAR__);
            current_statement_begin__ = 164;
            validate_non_negative_index("ind_st_sd", "N", N);
            validate_non_negative_index("ind_st_sd", "M", M);
            std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > ind_st_sd(M, Eigen::Matrix<double, Eigen::Dynamic, 1>(N));
            stan::math::initialize(ind_st_sd, DUMMY_VAR__);
            stan::math::fill(ind_st_sd, DUMMY_VAR__);
            current_statement_begin__ = 165;
            validate_non_negative_index("sha_lt", "N", N);
            Eigen::Matrix<double, Eigen::Dynamic, 1> sha_lt(N);
            stan::math::initialize(sha_lt, DUMMY_VAR__);
            stan::math::fill(sha_lt, DUMMY_VAR__);
            stan::math::assign(sha_lt,elt_multiply(prior_sha_lt_sd, sha_lt_raw));
            current_statement_begin__ = 166;
            validate_non_negative_index("ind_lt", "N", N);
            validate_non_negative_index("ind_lt", "M", M);
            std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > ind_lt(M, Eigen::Matrix<double, Eigen::Dynamic, 1>(N));
            stan::math::initialize(ind_lt, DUMMY_VAR__);
            stan::math::fill(ind_lt, DUMMY_VAR__);
            current_statement_begin__ = 167;
            validate_non_negative_index("ind_lt_sd", "N", N);
            Eigen::Matrix<double, Eigen::Dynamic, 1> ind_lt_sd(N);
            stan::math::initialize(ind_lt_sd, DUMMY_VAR__);
            stan::math::fill(ind_lt_sd, DUMMY_VAR__);
            stan::math::assign(ind_lt_sd,stan::math::sqrt(ind_lt_var));
            current_statement_begin__ = 168;
            validate_non_negative_index("ind_lt_covar", "N", N);
            validate_non_negative_index("ind_lt_covar", "N", N);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> ind_lt_covar(N, N);
            stan::math::initialize(ind_lt_covar, DUMMY_VAR__);
            stan::math::fill(ind_lt_covar, DUMMY_VAR__);
            stan::math::assign(ind_lt_covar,diag_post_multiply(diag_pre_multiply(ind_lt_sd, ind_lt_cor), ind_lt_sd));
            current_statement_begin__ = 169;
            validate_non_negative_index("ind_lt_cov_cholesky", "N", N);
            validate_non_negative_index("ind_lt_cov_cholesky", "N", N);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> ind_lt_cov_cholesky(N, N);
            stan::math::initialize(ind_lt_cov_cholesky, DUMMY_VAR__);
            stan::math::fill(ind_lt_cov_cholesky, DUMMY_VAR__);
            stan::math::assign(ind_lt_cov_cholesky,cholesky_decompose(ind_lt_covar));
            current_statement_begin__ = 172;
            validate_non_negative_index("x_hat", "((M + 2) * N)", ((M + 2) * N));
            Eigen::Matrix<double, Eigen::Dynamic, 1> x_hat(((M + 2) * N));
            stan::math::initialize(x_hat, DUMMY_VAR__);
            stan::math::fill(x_hat, DUMMY_VAR__);
            stan::math::assign(x_hat,append_row(prior_y_init_mean, rep_vector(0.0, (N * (M + 1)))));
            current_statement_begin__ = 173;
            validate_non_negative_index("SIGMA_init", "((M + 2) * N)", ((M + 2) * N));
            validate_non_negative_index("SIGMA_init", "((M + 2) * N)", ((M + 2) * N));
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> SIGMA_init(((M + 2) * N), ((M + 2) * N));
            stan::math::initialize(SIGMA_init, DUMMY_VAR__);
            stan::math::fill(SIGMA_init, DUMMY_VAR__);
            stan::math::assign(SIGMA_init,rep_matrix(0, ((M + 2) * N), ((M + 2) * N)));
            current_statement_begin__ = 175;
            validate_non_negative_index("sha_st_sd", "N", N);
            Eigen::Matrix<double, Eigen::Dynamic, 1> sha_st_sd(N);
            stan::math::initialize(sha_st_sd, DUMMY_VAR__);
            stan::math::fill(sha_st_sd, DUMMY_VAR__);
            stan::math::assign(sha_st_sd,stan::math::sqrt(sha_st_var));
            current_statement_begin__ = 176;
            validate_non_negative_index("SIGMA_mu", "N", N);
            validate_non_negative_index("SIGMA_mu", "N", N);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> SIGMA_mu(N, N);
            stan::math::initialize(SIGMA_mu, DUMMY_VAR__);
            stan::math::fill(SIGMA_mu, DUMMY_VAR__);
            stan::math::assign(SIGMA_mu,diag_post_multiply(diag_pre_multiply(sha_st_sd, sha_st_cor), sha_st_sd));
            current_statement_begin__ = 185;
            validate_non_negative_index("SIGMA", "((M + 2) * N)", ((M + 2) * N));
            validate_non_negative_index("SIGMA", "((M + 2) * N)", ((M + 2) * N));
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> SIGMA(((M + 2) * N), ((M + 2) * N));
            stan::math::initialize(SIGMA, DUMMY_VAR__);
            stan::math::fill(SIGMA, DUMMY_VAR__);
            stan::math::assign(SIGMA,rep_matrix(0, ((M + 2) * N), ((M + 2) * N)));
            current_statement_begin__ = 186;
            validate_non_negative_index("lt_discrepancies", "((M + 2) * N)", ((M + 2) * N));
            Eigen::Matrix<double, Eigen::Dynamic, 1> lt_discrepancies(((M + 2) * N));
            stan::math::initialize(lt_discrepancies, DUMMY_VAR__);
            stan::math::fill(lt_discrepancies, DUMMY_VAR__);
            current_statement_begin__ = 187;
            validate_non_negative_index("AR_params", "((M + 2) * N)", ((M + 2) * N));
            Eigen::Matrix<double, Eigen::Dynamic, 1> AR_params(((M + 2) * N));
            stan::math::initialize(AR_params, DUMMY_VAR__);
            stan::math::fill(AR_params, DUMMY_VAR__);
            // do transformed parameters statements
            current_statement_begin__ = 190;
            stan::model::assign(SIGMA, 
                        stan::model::cons_list(stan::model::index_min_max(1, N), stan::model::cons_list(stan::model::index_min_max(1, N), stan::model::nil_index_list())), 
                        SIGMA_t, 
                        "assigning variable SIGMA");
            current_statement_begin__ = 191;
            stan::model::assign(SIGMA, 
                        stan::model::cons_list(stan::model::index_min_max((N + 1), (2 * N)), stan::model::cons_list(stan::model::index_min_max((N + 1), (2 * N)), stan::model::nil_index_list())), 
                        SIGMA_mu, 
                        "assigning variable SIGMA");
            current_statement_begin__ = 192;
            for (int i = 1; i <= M; ++i) {
                current_statement_begin__ = 193;
                stan::model::assign(ind_st_sd, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            stan::math::sqrt(get_base1(ind_st_var, i, "ind_st_var", 1)), 
                            "assigning variable ind_st_sd");
                current_statement_begin__ = 195;
                stan::model::assign(SIGMA_x, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            diag_post_multiply(diag_pre_multiply(get_base1(ind_st_sd, i, "ind_st_sd", 1), get_base1(ind_st_cor, i, "ind_st_cor", 1)), get_base1(ind_st_sd, i, "ind_st_sd", 1)), 
                            "assigning variable SIGMA_x");
                current_statement_begin__ = 196;
                stan::model::assign(SIGMA, 
                            stan::model::cons_list(stan::model::index_min_max((((i + 1) * N) + 1), ((i + 2) * N)), stan::model::cons_list(stan::model::index_min_max((((i + 1) * N) + 1), ((i + 2) * N)), stan::model::nil_index_list())), 
                            get_base1(SIGMA_x, i, "SIGMA_x", 1), 
                            "assigning variable SIGMA");
            }
            current_statement_begin__ = 200;
            stan::model::assign(SIGMA_init, 
                        stan::model::cons_list(stan::model::index_min_max(1, N), stan::model::cons_list(stan::model::index_min_max(1, N), stan::model::nil_index_list())), 
                        diag_matrix(prior_y_init_var), 
                        "assigning variable SIGMA_init");
            current_statement_begin__ = 201;
            stan::model::assign(SIGMA_init, 
                        stan::model::cons_list(stan::model::index_min_max((N + 1), (2 * N)), stan::model::cons_list(stan::model::index_min_max((N + 1), (2 * N)), stan::model::nil_index_list())), 
                        elt_divide(SIGMA_mu, subtract(1, multiply(sha_st_ar_param, transpose(sha_st_ar_param)))), 
                        "assigning variable SIGMA_init");
            current_statement_begin__ = 202;
            for (int i = 1; i <= M; ++i) {
                current_statement_begin__ = 203;
                stan::model::assign(SIGMA_init, 
                            stan::model::cons_list(stan::model::index_min_max((((i + 1) * N) + 1), ((i + 2) * N)), stan::model::cons_list(stan::model::index_min_max((((i + 1) * N) + 1), ((i + 2) * N)), stan::model::nil_index_list())), 
                            elt_divide(get_base1(SIGMA_x, i, "SIGMA_x", 1), subtract(1, multiply(get_base1(ind_st_ar_param, i, "ind_st_ar_param", 1), transpose(get_base1(ind_st_ar_param, i, "ind_st_ar_param", 1))))), 
                            "assigning variable SIGMA_init");
            }
            current_statement_begin__ = 208;
            stan::model::assign(lt_discrepancies, 
                        stan::model::cons_list(stan::model::index_min_max(1, (2 * N)), stan::model::nil_index_list()), 
                        append_row(rep_vector(0.0, N), sha_lt), 
                        "assigning variable lt_discrepancies");
            current_statement_begin__ = 209;
            stan::model::assign(AR_params, 
                        stan::model::cons_list(stan::model::index_min_max(1, (2 * N)), stan::model::nil_index_list()), 
                        append_row(rep_vector(1.0, N), sha_st_ar_param), 
                        "assigning variable AR_params");
            current_statement_begin__ = 210;
            for (int i = 1; i <= M; ++i) {
                current_statement_begin__ = 211;
                stan::model::assign(ind_lt, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            multiply(ind_lt_cov_cholesky, get_base1(ind_lt_raw, i, "ind_lt_raw", 1)), 
                            "assigning variable ind_lt");
                current_statement_begin__ = 212;
                stan::model::assign(lt_discrepancies, 
                            stan::model::cons_list(stan::model::index_min_max((((i + 1) * N) + 1), ((i + 2) * N)), stan::model::nil_index_list()), 
                            get_base1(ind_lt, i, "ind_lt", 1), 
                            "assigning variable lt_discrepancies");
                current_statement_begin__ = 213;
                stan::model::assign(AR_params, 
                            stan::model::cons_list(stan::model::index_min_max((((i + 1) * N) + 1), ((i + 2) * N)), stan::model::nil_index_list()), 
                            get_base1(ind_st_ar_param, i, "ind_st_ar_param", 1), 
                            "assigning variable AR_params");
            }
            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            // write transformed parameters
            if (include_tparams__) {
                size_t SIGMA_x_j_2_max__ = N;
                size_t SIGMA_x_j_1_max__ = N;
                size_t SIGMA_x_k_0_max__ = M;
                for (size_t j_2__ = 0; j_2__ < SIGMA_x_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < SIGMA_x_j_1_max__; ++j_1__) {
                        for (size_t k_0__ = 0; k_0__ < SIGMA_x_k_0_max__; ++k_0__) {
                            vars__.push_back(SIGMA_x[k_0__](j_1__, j_2__));
                        }
                    }
                }
                size_t ind_st_sd_j_1_max__ = N;
                size_t ind_st_sd_k_0_max__ = M;
                for (size_t j_1__ = 0; j_1__ < ind_st_sd_j_1_max__; ++j_1__) {
                    for (size_t k_0__ = 0; k_0__ < ind_st_sd_k_0_max__; ++k_0__) {
                        vars__.push_back(ind_st_sd[k_0__](j_1__));
                    }
                }
                size_t sha_lt_j_1_max__ = N;
                for (size_t j_1__ = 0; j_1__ < sha_lt_j_1_max__; ++j_1__) {
                    vars__.push_back(sha_lt(j_1__));
                }
                size_t ind_lt_j_1_max__ = N;
                size_t ind_lt_k_0_max__ = M;
                for (size_t j_1__ = 0; j_1__ < ind_lt_j_1_max__; ++j_1__) {
                    for (size_t k_0__ = 0; k_0__ < ind_lt_k_0_max__; ++k_0__) {
                        vars__.push_back(ind_lt[k_0__](j_1__));
                    }
                }
                size_t ind_lt_sd_j_1_max__ = N;
                for (size_t j_1__ = 0; j_1__ < ind_lt_sd_j_1_max__; ++j_1__) {
                    vars__.push_back(ind_lt_sd(j_1__));
                }
                size_t ind_lt_covar_j_2_max__ = N;
                size_t ind_lt_covar_j_1_max__ = N;
                for (size_t j_2__ = 0; j_2__ < ind_lt_covar_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < ind_lt_covar_j_1_max__; ++j_1__) {
                        vars__.push_back(ind_lt_covar(j_1__, j_2__));
                    }
                }
                size_t ind_lt_cov_cholesky_j_2_max__ = N;
                size_t ind_lt_cov_cholesky_j_1_max__ = N;
                for (size_t j_2__ = 0; j_2__ < ind_lt_cov_cholesky_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < ind_lt_cov_cholesky_j_1_max__; ++j_1__) {
                        vars__.push_back(ind_lt_cov_cholesky(j_1__, j_2__));
                    }
                }
                size_t x_hat_j_1_max__ = ((M + 2) * N);
                for (size_t j_1__ = 0; j_1__ < x_hat_j_1_max__; ++j_1__) {
                    vars__.push_back(x_hat(j_1__));
                }
                size_t SIGMA_init_j_2_max__ = ((M + 2) * N);
                size_t SIGMA_init_j_1_max__ = ((M + 2) * N);
                for (size_t j_2__ = 0; j_2__ < SIGMA_init_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < SIGMA_init_j_1_max__; ++j_1__) {
                        vars__.push_back(SIGMA_init(j_1__, j_2__));
                    }
                }
                size_t sha_st_sd_j_1_max__ = N;
                for (size_t j_1__ = 0; j_1__ < sha_st_sd_j_1_max__; ++j_1__) {
                    vars__.push_back(sha_st_sd(j_1__));
                }
                size_t SIGMA_mu_j_2_max__ = N;
                size_t SIGMA_mu_j_1_max__ = N;
                for (size_t j_2__ = 0; j_2__ < SIGMA_mu_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < SIGMA_mu_j_1_max__; ++j_1__) {
                        vars__.push_back(SIGMA_mu(j_1__, j_2__));
                    }
                }
                size_t SIGMA_j_2_max__ = ((M + 2) * N);
                size_t SIGMA_j_1_max__ = ((M + 2) * N);
                for (size_t j_2__ = 0; j_2__ < SIGMA_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < SIGMA_j_1_max__; ++j_1__) {
                        vars__.push_back(SIGMA(j_1__, j_2__));
                    }
                }
                size_t lt_discrepancies_j_1_max__ = ((M + 2) * N);
                for (size_t j_1__ = 0; j_1__ < lt_discrepancies_j_1_max__; ++j_1__) {
                    vars__.push_back(lt_discrepancies(j_1__));
                }
                size_t AR_params_j_1_max__ = ((M + 2) * N);
                for (size_t j_1__ = 0; j_1__ < AR_params_j_1_max__; ++j_1__) {
                    vars__.push_back(AR_params(j_1__));
                }
            }
            if (!include_gqs__) return;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_ensemble_prior";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t ind_st_ar_param_j_1_max__ = N;
        size_t ind_st_ar_param_k_0_max__ = M;
        for (size_t j_1__ = 0; j_1__ < ind_st_ar_param_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < ind_st_ar_param_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "ind_st_ar_param" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t ind_st_var_j_1_max__ = N;
        size_t ind_st_var_k_0_max__ = M;
        for (size_t j_1__ = 0; j_1__ < ind_st_var_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < ind_st_var_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "ind_st_var" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t ind_st_cor_j_2_max__ = N;
        size_t ind_st_cor_j_1_max__ = N;
        size_t ind_st_cor_k_0_max__ = M;
        for (size_t j_2__ = 0; j_2__ < ind_st_cor_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < ind_st_cor_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < ind_st_cor_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "ind_st_cor" << '.' << k_0__ + 1 << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }
        size_t ind_lt_raw_j_1_max__ = N;
        size_t ind_lt_raw_k_0_max__ = M;
        for (size_t j_1__ = 0; j_1__ < ind_lt_raw_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < ind_lt_raw_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "ind_lt_raw" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t ind_lt_var_j_1_max__ = N;
        for (size_t j_1__ = 0; j_1__ < ind_lt_var_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ind_lt_var" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t ind_lt_cor_j_2_max__ = N;
        size_t ind_lt_cor_j_1_max__ = N;
        for (size_t j_2__ = 0; j_2__ < ind_lt_cor_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < ind_lt_cor_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "ind_lt_cor" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t sha_st_ar_param_j_1_max__ = N;
        for (size_t j_1__ = 0; j_1__ < sha_st_ar_param_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sha_st_ar_param" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t sha_st_var_j_1_max__ = N;
        for (size_t j_1__ = 0; j_1__ < sha_st_var_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sha_st_var" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t sha_st_cor_j_2_max__ = N;
        size_t sha_st_cor_j_1_max__ = N;
        for (size_t j_2__ = 0; j_2__ < sha_st_cor_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < sha_st_cor_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "sha_st_cor" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t sha_lt_raw_j_1_max__ = N;
        for (size_t j_1__ = 0; j_1__ < sha_lt_raw_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sha_lt_raw" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t SIGMA_t_j_2_max__ = N;
        size_t SIGMA_t_j_1_max__ = N;
        for (size_t j_2__ = 0; j_2__ < SIGMA_t_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < SIGMA_t_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "SIGMA_t" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t SIGMA_x_j_2_max__ = N;
            size_t SIGMA_x_j_1_max__ = N;
            size_t SIGMA_x_k_0_max__ = M;
            for (size_t j_2__ = 0; j_2__ < SIGMA_x_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < SIGMA_x_j_1_max__; ++j_1__) {
                    for (size_t k_0__ = 0; k_0__ < SIGMA_x_k_0_max__; ++k_0__) {
                        param_name_stream__.str(std::string());
                        param_name_stream__ << "SIGMA_x" << '.' << k_0__ + 1 << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                        param_names__.push_back(param_name_stream__.str());
                    }
                }
            }
            size_t ind_st_sd_j_1_max__ = N;
            size_t ind_st_sd_k_0_max__ = M;
            for (size_t j_1__ = 0; j_1__ < ind_st_sd_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < ind_st_sd_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "ind_st_sd" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t sha_lt_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < sha_lt_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "sha_lt" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t ind_lt_j_1_max__ = N;
            size_t ind_lt_k_0_max__ = M;
            for (size_t j_1__ = 0; j_1__ < ind_lt_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < ind_lt_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "ind_lt" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t ind_lt_sd_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < ind_lt_sd_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "ind_lt_sd" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t ind_lt_covar_j_2_max__ = N;
            size_t ind_lt_covar_j_1_max__ = N;
            for (size_t j_2__ = 0; j_2__ < ind_lt_covar_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < ind_lt_covar_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "ind_lt_covar" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t ind_lt_cov_cholesky_j_2_max__ = N;
            size_t ind_lt_cov_cholesky_j_1_max__ = N;
            for (size_t j_2__ = 0; j_2__ < ind_lt_cov_cholesky_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < ind_lt_cov_cholesky_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "ind_lt_cov_cholesky" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t x_hat_j_1_max__ = ((M + 2) * N);
            for (size_t j_1__ = 0; j_1__ < x_hat_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "x_hat" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t SIGMA_init_j_2_max__ = ((M + 2) * N);
            size_t SIGMA_init_j_1_max__ = ((M + 2) * N);
            for (size_t j_2__ = 0; j_2__ < SIGMA_init_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < SIGMA_init_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "SIGMA_init" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t sha_st_sd_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < sha_st_sd_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "sha_st_sd" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t SIGMA_mu_j_2_max__ = N;
            size_t SIGMA_mu_j_1_max__ = N;
            for (size_t j_2__ = 0; j_2__ < SIGMA_mu_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < SIGMA_mu_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "SIGMA_mu" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t SIGMA_j_2_max__ = ((M + 2) * N);
            size_t SIGMA_j_1_max__ = ((M + 2) * N);
            for (size_t j_2__ = 0; j_2__ < SIGMA_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < SIGMA_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "SIGMA" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t lt_discrepancies_j_1_max__ = ((M + 2) * N);
            for (size_t j_1__ = 0; j_1__ < lt_discrepancies_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "lt_discrepancies" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t AR_params_j_1_max__ = ((M + 2) * N);
            for (size_t j_1__ = 0; j_1__ < AR_params_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "AR_params" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t ind_st_ar_param_j_1_max__ = N;
        size_t ind_st_ar_param_k_0_max__ = M;
        for (size_t j_1__ = 0; j_1__ < ind_st_ar_param_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < ind_st_ar_param_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "ind_st_ar_param" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t ind_st_var_j_1_max__ = N;
        size_t ind_st_var_k_0_max__ = M;
        for (size_t j_1__ = 0; j_1__ < ind_st_var_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < ind_st_var_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "ind_st_var" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t ind_st_cor_j_1_max__ = ((N * (N - 1)) / 2);
        size_t ind_st_cor_k_0_max__ = M;
        for (size_t j_1__ = 0; j_1__ < ind_st_cor_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < ind_st_cor_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "ind_st_cor" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t ind_lt_raw_j_1_max__ = N;
        size_t ind_lt_raw_k_0_max__ = M;
        for (size_t j_1__ = 0; j_1__ < ind_lt_raw_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < ind_lt_raw_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "ind_lt_raw" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t ind_lt_var_j_1_max__ = N;
        for (size_t j_1__ = 0; j_1__ < ind_lt_var_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ind_lt_var" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t ind_lt_cor_j_1_max__ = ((N * (N - 1)) / 2);
        for (size_t j_1__ = 0; j_1__ < ind_lt_cor_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ind_lt_cor" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t sha_st_ar_param_j_1_max__ = N;
        for (size_t j_1__ = 0; j_1__ < sha_st_ar_param_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sha_st_ar_param" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t sha_st_var_j_1_max__ = N;
        for (size_t j_1__ = 0; j_1__ < sha_st_var_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sha_st_var" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t sha_st_cor_j_1_max__ = ((N * (N - 1)) / 2);
        for (size_t j_1__ = 0; j_1__ < sha_st_cor_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sha_st_cor" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t sha_lt_raw_j_1_max__ = N;
        for (size_t j_1__ = 0; j_1__ < sha_lt_raw_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sha_lt_raw" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t SIGMA_t_j_1_max__ = (N + ((N * (N - 1)) / 2));
        for (size_t j_1__ = 0; j_1__ < SIGMA_t_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "SIGMA_t" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t SIGMA_x_j_2_max__ = N;
            size_t SIGMA_x_j_1_max__ = N;
            size_t SIGMA_x_k_0_max__ = M;
            for (size_t j_2__ = 0; j_2__ < SIGMA_x_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < SIGMA_x_j_1_max__; ++j_1__) {
                    for (size_t k_0__ = 0; k_0__ < SIGMA_x_k_0_max__; ++k_0__) {
                        param_name_stream__.str(std::string());
                        param_name_stream__ << "SIGMA_x" << '.' << k_0__ + 1 << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                        param_names__.push_back(param_name_stream__.str());
                    }
                }
            }
            size_t ind_st_sd_j_1_max__ = N;
            size_t ind_st_sd_k_0_max__ = M;
            for (size_t j_1__ = 0; j_1__ < ind_st_sd_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < ind_st_sd_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "ind_st_sd" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t sha_lt_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < sha_lt_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "sha_lt" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t ind_lt_j_1_max__ = N;
            size_t ind_lt_k_0_max__ = M;
            for (size_t j_1__ = 0; j_1__ < ind_lt_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < ind_lt_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "ind_lt" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t ind_lt_sd_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < ind_lt_sd_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "ind_lt_sd" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t ind_lt_covar_j_2_max__ = N;
            size_t ind_lt_covar_j_1_max__ = N;
            for (size_t j_2__ = 0; j_2__ < ind_lt_covar_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < ind_lt_covar_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "ind_lt_covar" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t ind_lt_cov_cholesky_j_2_max__ = N;
            size_t ind_lt_cov_cholesky_j_1_max__ = N;
            for (size_t j_2__ = 0; j_2__ < ind_lt_cov_cholesky_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < ind_lt_cov_cholesky_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "ind_lt_cov_cholesky" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t x_hat_j_1_max__ = ((M + 2) * N);
            for (size_t j_1__ = 0; j_1__ < x_hat_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "x_hat" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t SIGMA_init_j_2_max__ = ((M + 2) * N);
            size_t SIGMA_init_j_1_max__ = ((M + 2) * N);
            for (size_t j_2__ = 0; j_2__ < SIGMA_init_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < SIGMA_init_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "SIGMA_init" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t sha_st_sd_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < sha_st_sd_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "sha_st_sd" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t SIGMA_mu_j_2_max__ = N;
            size_t SIGMA_mu_j_1_max__ = N;
            for (size_t j_2__ = 0; j_2__ < SIGMA_mu_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < SIGMA_mu_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "SIGMA_mu" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t SIGMA_j_2_max__ = ((M + 2) * N);
            size_t SIGMA_j_1_max__ = ((M + 2) * N);
            for (size_t j_2__ = 0; j_2__ < SIGMA_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < SIGMA_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "SIGMA" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t lt_discrepancies_j_1_max__ = ((M + 2) * N);
            for (size_t j_1__ = 0; j_1__ < lt_discrepancies_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "lt_discrepancies" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t AR_params_j_1_max__ = ((M + 2) * N);
            for (size_t j_1__ = 0; j_1__ < AR_params_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "AR_params" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
    }
}; // model
}  // namespace
typedef model_ensemble_prior_namespace::model_ensemble_prior stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
