% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/algorithms.R
\name{sim5}
\alias{sim5}
\title{Sim5 Co-occurrence Randomization Algorithm}
\usage{
sim5(speciesData)
}
\arguments{
\item{speciesData}{binary presence-absence matrix
(rows = species, columns = sites).}
}
\value{
Returns a binary presence-absence matrix with the same
dimensions and colsums as the input matrix.
}
\description{
Randomizes a binary matrix speciesData by reshuffling elements
within each column. Sampling weights for each row are proportional to
row sums. Makes a call to the vector_sample function.
}
\details{
This algorithm preserves differences among sites in species
richness, but assumes differences among species in commonness and rarity
are proportional to observed species occurrences (= row sums).
}
\note{
This algorithm preserves differences among sites in species richness
(= colsums), but assumes differences among species in commonness and rarity
are proportional to observed species occurrences (= rowsums). sim5 has a
high frequency of Type I errors with random matrices, so it is not
recommended for co-occurrence analysis.
}
\examples{
randomMatrix <- sim5(speciesData = matrix(rbinom(40,1,0.5),nrow=8))
}
\references{
Gotelli, N.J. 2000. Null model analysis of species co-occurrence
patterns. Ecology 81: 2606-2621.
}

