% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intEcoVirtual.R
\name{anima}
\alias{anima}
\alias{animaCena}
\alias{animaGame}
\alias{animaHub}
\alias{animaIsl}
\alias{animaMeta2}
\alias{animaMetaComp}
\alias{animaRandWalk}
\alias{gr.toff}
\alias{grColExt}
\alias{grFim}
\title{Internal EcoVirtual Graphics and Animations}
\usage{
grColExt(E, I, P, area)
}
\arguments{
\item{E}{extinction rate}

\item{I}{colonization rate}

\item{P}{species available in mainland}

\item{area}{islands sizes}
}
\value{
Show simulation in a graphic device.
}
\description{
Internal functions for graphics and animations of the simulations results.
}
\details{
The list below relates each function graphical and its primary functions:

animaCena - regNicho

animaGame - extGame

animaHub - simHub1, simHub2, simHub3

animaIsl - archip

animaMeta2 - metaPop, metaCi, metaEr, metaCiEr

animaMetaComp - metaComp

animaRandWalk - randWalk

grColExt - animaColExt, bioGeoIsl

grFim - metaPop, metaCi, metaEr, metaCiEr
}
\examples{

\dontrun{
grColExt(E = 0.5 , I = 0.5 , P = 100, area=1:10)
}

}
\author{
Alexandre Adalardo de Oliveira \email{ecovirtualpackage@gmail.com}
}
\seealso{
\url{http://ecovirtual.ib.usp.br}
}
\keyword{simulation}

