% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Clustergram.R
\name{clustergramInd}
\alias{clustergramInd}
\title{Clustergram with fuzzy indices plot}
\usage{
clustergramInd(Data, k.range = 2:10,
  clustering.function = clustergram.kmeans,
  clustergram.plot = clustergram.plot.matlines,
  FuzzyIndice.plot = FuzzyIndice.plot.matlines, line.width = 0.004,
  add.center.points = TRUE, ...)
}
\arguments{
\item{Data}{Should be a scales matrix. Where each column belongs to a
different dimension of the observations.}

\item{k.range}{A vector with the number of clusters to plot the clustergram
for.}

\item{clustering.function}{Which clustering method to be used. Default is
k-means. Can be FCM is set to clustergram.vegclust. See details}

\item{clustergram.plot}{Type of plot for the clustergram output. See details.}

\item{FuzzyIndice.plot}{Type of plot for the fuzzy indices output. See
details.}

\item{line.width}{Graphical parameter. Width of the lines.}

\item{add.center.points}{Logical. Should the cluster means be plotted (as
points).}

\item{...}{Additional arguments to be passed to the clustering function.}
}
\value{
A clustergram plot and a fuzzy indices evolution plot of the inputed
  data
}
\description{
Clustergram with fuzzy indices plot
}
\details{
This clustergram fuction produces an additional plot with the
  evolution of the main fuzzy indices (normalized partition coefficient (PCN)
  and normalized partition entropy (PEN)). Maximum values of PCN or minimum
  values of PEN can be used as criteria to choose the number of clusters.
}
\examples{
\donttest{
####### Example data:
   SyntheticTrial <- SyntheticData(SpeciesNum = 100,
                                   CommunityNum = 3, SpCo = NULL,
                                   Length = 500,
                                   Parameters = list(a=c(40, 80, 50),
                                                     b=c(100,250,400),
                                                     c=rep(0.03,3)),
                                   dev.c = .015, pal = c("#008585", "#FBF2C4", "#C7522B"))

   ######## clustergram plots with fuzzy indices plots:
   clustergramInd(as.matrix(SyntheticTrial[,2:ncol(SyntheticTrial)]),
                                 clustering.function = clustergram.vegclust.Ind,
                                 clustergram.plot = clustergram.plot.matlines,
                                 FuzzyIndice.plot = FuzzyIndice.plot.matlines,
                                 k.range = 2:10, line.width = .2)
 }

}
