% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotEcotone.R
\name{plotSlope}
\alias{plotSlope}
\title{Plotting component for Slope}
\usage{
plotSlope(ecotoneslope, plot.data = FALSE, plot.method = c("none",
  "dca_slope", "fanny_slope", "vegclust_slope", "cmeans_slope",
  "diversity_slope"), axis.number = 1, magnification = 500,
  col.data = "black", col.method = c("red", "blue"), title = NULL,
  ylab = "Species", xlab = "Gradient", na.rm = FALSE, alone = TRUE,
  ...)
}
\arguments{
\item{ecotoneslope}{A list containing elements named in the same way than
Slope function outcomes}

\item{plot.data}{Logical. Should the data be plotted.}

\item{plot.method}{Analysis method to be plotted from the Slope results. Must
be one or several of "none", "dca_slope","fanny_slope","vegclust_slope",
"cmeans_slope" or "diversity_slope".}

\item{axis.number}{Number of axis to plot from the DCA.}

\item{magnification}{Magnification coefficient for the method. Usefull if the
data are being plotted.}

\item{col.data}{Colors to be used for the data. See CommunityColor function.}

\item{col.method}{Colors to be used for the methods.}

\item{title}{An overall title for the plot. See plot.}

\item{ylab}{A title for the y-axis. See plot.}

\item{xlab}{A title for the x-axis. See plot.}

\item{na.rm}{Logical. Should NAs be removed.}

\item{alone}{Logical. If FALSE, lines are added to an existing plot.}

\item{...}{Additional argument to be passed to the plot function.}
}
\value{
A plot with the Slope results along the gradient, and optionally, the
  data.
}
\description{
Plotting component for Slope
}
\details{
Internal component of the PlotEcotone function for the plotting of
  the Slope analyses. Use PlotEcotone directly for more options.
}
\examples{
 ######## Artificial dataset & analysis:
 SyntheticTrial <- SyntheticData(SpeciesNum = 20, CommunityNum = 3,
                                 SpCo = NULL, Length = 500,
                                 Parameters = list(a=rep(60, 3),
                                                   b=c(0,250,500),
                                                   c=rep(0.03,3)),
                                 dev.c = .015, pal = c("#008585", "#FBF2C4", "#C7522B"))

 SyntheticEcoFinder <- EcotoneFinder(SyntheticTrial[,-1],
                                     dist = SyntheticTrial$Distance,
                                     method = "all", groups = 3,
                                     standardize = "hellinger",
                                     diversity = "all")

 ### Derivatives:
 SyntheticSlope <- Slope(SyntheticEcoFinder, method = "all",
                         axis.number = 2, diversity = "all")

### Plot:
require(colorspace)
plotSlope(SyntheticSlope, plot.data = FALSE,
          plot.method = c("cmeans_slope", "vegclust_slope"),
          col.method = terrain_hcl(3))


}
