% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/showWeights.R
\name{getWeightJkReplicates}
\alias{getWeightJkReplicates}
\title{Retrieve the Jackknife Replicate Weights}
\usage{
getWeightJkReplicates(var, data)
}
\arguments{
\item{var}{character indicating the name of the weight variable for which the
jackknife replicate weights are desired}

\item{data}{an \code{edsurvey.data.frame}, a \code{light.edsurvey.data.frame}, or an \code{edsurvey.data.frame.list}}
}
\value{
a character vector of the jackknife replicate weights
}
\description{
Returns the jackknife replicate weights on an \code{edsurvey.data.frame}, a \code{light.edsurvey.data.frame}, or
             an \code{edsurvey.data.frame.list} associated with a weight variable.
}
\examples{
\dontrun{
# read in the example data (generated, not real student data)
sdf <- readNAEP(path=system.file("extdata/data", "M36NT2PM.dat", package="NAEPprimer"))

getWeightJkReplicates(var="origwt", data=sdf)
}
}
\author{
Michael Lee and Paul Bailey
}
