% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vario.mod.function.gstat.R
\name{vario.mod}
\alias{vario.mod}
\title{Semi-variogram modeling function}
\usage{
vario.mod(
  data,
  max.dist = c(2000, 1500, 1000, 750, 500, 250),
  nbins = 13,
  shinyresults = TRUE,
  windowplots = FALSE,
  pdf = FALSE,
  pdf.directory = getwd(),
  pdf.name = "Semivariograms"
)
}
\arguments{
\item{data}{A data frame or matrix containing the x-coordinates  in the first column,
the y-coordinates  in the second column (by default in meters)
and the data values in the third column.
The dataset may contain more attributes in further columns. In this case, a warning is provided.
All columns beyond the third one are ignored.}

\item{max.dist}{An optional numeric argument; the default is the vector \code{c(2000,1500,1000,750,500,250)}.
Either a scalar or vector containing the maximal distances can be inserted. If a vector is
provided, the \code{ nbins} argument must be either a scalar or a vector of the same length.}

\item{nbins}{An optional argument; the default is 13 bins for all empirical semi-variograms to be estimated.
Either a scalar or vector containing the number of bins can be inserted. If a vector is
provided, the \code{max.dist} argument must be either a scalar or a vector of the same length.}

\item{shinyresults}{A logical argument; by default TRUE. If \code{shinyresults = T},
the information table and graphics of
all estimated semi-variogram models can be observed in an automatically generated
shiny application.}

\item{windowplots}{A logical argument; by default FALSE. If \code{windowplots = T}, all graphics are
opened in new windows. They can be observed and saved manually in a wished format.}

\item{pdf}{A logical argument; by default FALSE. If \code{pdf = T}, all graphics are saved in a pdf file.
The file path and the name of the pdf file can be specified by the following two arguments
\code{pdf.directory} and \code{pdf.name}.}

\item{pdf.directory}{A character argument to specify the folder in which the pdf file is saved.
If no file path is given, the pdf file is saved in the current working directory identified
by \code{getwd()}.}

\item{pdf.name}{A character argument to specify the name of the pdf file. If no name is provided, the
file is saved as 'Semivariograms.pdf'.}
}
\value{
A list containing the following arguments:
\item{infotable}{A table containing the statistics of all estimated exponential semi-variogram models.
      Each row corresponds to one model.
      Shown are the prespecified \code{max.dist} and \code{nbins} values, the parameter estimates for the nugget effect, partial
      sill and shape, the resulting estimated practical range,
      the relative structured variability (RSV) and the relative bias.}
\item{variog.list}{A list: each list entry contains the \code{variog} output with further information
     on the estimated empirical semi-variogram.}
\item{vmod.list}{A list: each list entry contains the \code{variofit} output with further information
     on the fitted parametric semi-variogram model.}
\item{input.arguments}{A list containing the evaluated input arguments, namely the \code{$data} used to fit the
      exponential semi-variogram, the \code{$max.dist} and \code{$nbins} specifications and the
      specifications for the pdf-output, \code{$pdf}, \code{$pdf.directory} and \code{$pdf.name}.}
\item{call}{Contains the call of the function.}

The models are visualized in an automatically opened shiny application if \code{shinyresults = T}. Beware
that in this case the output of the \code{vario.mod} function is not saved in the environment, even with a variable name assigned.
In order to save the output, set \code{shinyresults = F}.

If the argument \code{windowplots = T}, one or multiple graphics of the estimated
empirical semi-variograms and semi-variogram models are plotted in the R environment.
If the argument \code{pdf = T}, a pdf file containing the same figures is saved in the manually
specified or current working directory.
}
\description{
The function allows for user friendly exponential semi-variogram model fitting to data.
Based on the \code{gstat} function \code{variogram}, \code{vgm} and \code{fit.variogram}, the function fits one
or multiple exponential semi-variogram models given one or multiple maximal distances and number of bins.
All estimated model parameters are summarized in an information table.
Graphics of all models can be observed in a shiny application output
or in several plot windows, one for each empirical semi-variogram.
Additionally, a pdf file including all the figures can be
saved in a specified working directory.
}
\details{
\strong{Prespecification and Interpretation of max.dist and nbins arguments:}

         \code{max.dist}:
         only data pairs with a separation smaller than the prespecified maximal distance are included in the semi-variogram
         estimation. Data pairs that are separated by a higher distance are excluded.

         \code{nbins}: the interval (0, \code{max.dist}] is separated into \code{nbins} equidistant
         lag bins or intervals, respectively. Each pairwise distance is then assigned to one of the
         bins. The point pair subsets \eqn{N(h_k) := \{(\mathbf{s_i}, \mathbf{s_j}) \in D |\;\; ||\mathbf{s_i}-\mathbf{s_j}|| \in Bin_k\}}
         are defined
         and a point estimate of the semi-variogram is estimated for each \eqn{Bin_k} for \eqn{k =1,...}\code{nbins}.


         \strong{Empirical semi-variogram estimator:}

         Using the \code{gstat} function \code{variogram} an empirical semi-variogram according to
         Matheron's semi-variogram estimator \insertCite{matheron1962traite}{EgoCor}
         \deqn{\hat{\gamma}(h) = \frac{1}{2\cdot|N(h)|} \sum_{(\mathbf{s_i},
         \mathbf{s_j}) \in N(h)}\{Z(\mathbf{s_i})- Z(\mathbf{s_j})\}^2}
         with \eqn{N(h)} defined as above is obtained.


         \strong{Exponential semi-variogram model:}

         Based on the empirical semi-variogram an exponential semi-variogram model of the form
         \insertCite{Cressie.1993}{EgoCor}
         \deqn{\gamma_{exp}(h) =  c_0 + \sigma_0^2 \Big\{1 - \exp\big(- \frac{h}{\phi}\big)\Big\}}
         for \eqn{h > 0}
         is fitted using the \code{vgm} and \code{fit.variogram} function from package \code{gstat} via
         weighted least squares estimation. The weights have the form
         \eqn{ w_k = \vert N(h_k) \vert / h_k^2} specified by the \code{fit.method = 7} argument
         within the \code{fit.variogram} function.

         For the numerical optimization, starting values for the model parameters have to be provided.
         The initial value for the partial sill \eqn{\sigma_0^2} equals the empirical variance of
         the observations. The starting value for the nugget effect \eqn{c_0} is set to zero.
         The initial value for the shape parameter \eqn{\phi} is set as \code{max.dist} divided by 3.



         \strong{Result statistics:}

         The results for all models are automatically printed when running the function and can be
         found under \code{function.output$infotable}. Part of the table contains a repetition of the
         specified \code{max.dist} and \code{nbins} parameters as well as the estimated model parameters.
         The additional statistics within the infotable output are the following:

         Practical range: In case of the exponential semi-variogram model, the
         sill \eqn{\sigma^2 = c_0 + \sigma_0^2} is only reached asymptotically. The distance \eqn{H}
         at which \eqn{\gamma(h^* = 0.95 \cdot \sigma^2)} is called the practical range.
         Formally, the practical range is
         defined as
         \deqn{prac.range = \frac{1}{\phi} log\Big( \frac{\sigma_0^2}{0.05(c_0 + \sigma_0^2)} \Big).}

         Relative Structural Variability (RSV): The relative structural variability is a measure of
         the proportion of the total variance with a spatial structure and
         defined as
         \deqn{RSV = \frac{\sigma_0^2}{c_0 + \sigma_0^2}.}

         Relative Bias: The relative bias describes the proportion of the total variance according
         to the semi-variogram model to the true total variance. It is estimated as
         \deqn{rel. bias = \frac{c_0 + \sigma_0^2}{\widehat{Var(Z)}},}
         where \eqn{\widehat{Var(Z)}} is the sample variance or empirical variance of the attribute of
         interest of the dataset at hand.
         A relative bias of 1 indicates equality of
         sample variance and variance according to the semi-variogram model.

         For more details, see \insertCite{schabenberger2017statistical;textual}{EgoCor}.
}
\examples{
if(interactive()){

## Example 1
# Default options:
vario.mod(data = birth)

# This is equal to
vario.mod(data = birth, max.dist = c(2000,1500,1000,750,500,250), nbins = 13,
          shinyresults = TRUE, windowplots = FALSE,
          pdf = FALSE, pdf.directory = getwd(), pdf.name = "Semivariograms")

## Example 2
# Open graphics in regular windows and not in shiny application:
vario.mod(data = birth, max.dist = c(2000,1500,1000,750,500,250), nbins = 15:10,
          shinyresults = FALSE, windowplots = TRUE)

## Example 3
# Generate a pdf with the following command:
vario.mod(data = birth, shinyresults = FALSE, windowplots = FALSE,
          pdf = TRUE, pdf.directory = getwd())
# You find a pdf file in your current working directory.

}


}
\references{
\insertAllCited{}
}
\seealso{
\code{variogram} in the \code{gstat} package for further information on
         the estimation of the empirical semi-variogram;

         \code{fit.variogram} and \code{vgm} in the \code{gstat} package for further information on the default settings
         when fitting an exponential semi-variogram model to an empirical semi-variogram.
}
