% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/presence_summary.R
\name{presence_summary}
\alias{presence_summary}
\title{Summarize presence data}
\usage{
presence_summary(presence, from = NULL, to = NULL)
}
\arguments{
\item{presence}{a data.frame with one date column (needs to be named "Date") and columns for each individual with 0/1 indicating absence/presence of that individual on that date}

\item{from}{character indicating the beginning of the period to be considered (by default the first date in the Date column)}

\item{to}{character indicating the end of the period to be considered (by default the last date in the Date column)}
}
\value{
a data.frame with entries for each individual indicating the first and last dates of their stays.
}
\description{
Summarize presence data
}
\details{
If an individual left and/or joined multiple times, this will be indicated by the \code{stint} column.

The \code{init} column marks those individuals that were present on the beginning of the period considered.
}
\examples{
data(advpres)
presence_summary(advpres)

presence_summary(advpres, from = "2010-01-27", to = "2010-02-02")
}
