% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/som.R
\name{GQTSOM}
\alias{GQTSOM}
\title{Train a Growing Quadtree Self-Organizing Map}
\usage{
GQTSOM(
  data,
  init.dim = c(3, 3),
  target_codes = 100,
  rlen = 10,
  radius = c(sqrt(sum(init.dim^2)), 0.5),
  epochRadii = seq(radius[1], radius[2], length.out = rlen),
  coords = NULL,
  codes = NULL,
  coordsFn = NULL,
  importance = NULL,
  distf = 2,
  nhbr.distf = 2,
  noMapping = F,
  parallel = F,
  threads = if (parallel) 0 else 1
)
}
\arguments{
\item{data}{Input data matrix}

\item{init.dim}{Initial size of the SOM, default \code{c(3,3)}}

\item{target_codes}{Make the SOM grow linearly to at most this amount of nodes (default \code{100})}

\item{rlen}{Number of training iterations}

\item{radius}{Start and end training radius, as in \code{\link[=SOM]{SOM()}}}

\item{epochRadii}{Precise radii for each epoch (must be of length \code{rlen})}

\item{coords}{Quadtree coordinates of the initial SOM nodes.}

\item{codes}{Initial codebook}

\item{coordsFn}{Function to generate/transform grid coordinates (e.g. \code{\link[=tSNECoords]{tSNECoords()}}). If \code{NULL} (default), the grid is the grid is the 2D coordinates of GQTSOM map.}

\item{importance}{Weights of input data dimensions}

\item{distf}{Distance measure to use in input data space (1=manhattan, 2=euclidean, 3=chebyshev, 4=cosine)}

\item{nhbr.distf}{Distance measure to use in output space (as in \code{distf})}

\item{noMapping}{If \code{TRUE}, do not compute the assignment of input data to SOM nodes}

\item{parallel}{Parallelize the training by setting appropriate \code{threads}. Defaults to \code{FALSE}.}

\item{threads}{Number of threads to use for training. Defaults to 0 (chooses maximum available hardware threads) if \code{parallel=TRUE} or 1 (single thread) if \code{parallel=FALSE}.}
}
\description{
Train a Growing Quadtree Self-Organizing Map
}
