% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CLASS__MinimizerOpts.R
\docType{class}
\name{MinimizerOpts}
\alias{MinimizerOpts}
\title{EmiR optimization options}
\description{
\loadmathjax
A S4 class storing the options for the optimization algorithms in EmiR.
}
\section{Slots}{

\describe{
\item{\code{maximize}}{if \code{TRUE} the objective function is maximized instead of being minimized. Default is \code{FALSE}.}

\item{\code{silent_mode}}{if \code{TRUE} no output to console is generated. Default is \code{FALSE}.}

\item{\code{save_pop_history}}{if \code{TRUE} the position of all individuals in the population at
each iteration is stored. This is necessary for functions like \code{plot_population} and \code{animate_population}
to work. Default is \code{FALSE}.}

\item{\code{constrained_method}}{method for constrained optimization. Possible values are:
\itemize{
\item \code{"PENALTY"} - Penalty Method: the constrained problem is converted to an unconstrained one,
by adding a \emph{penalty function} to the objective function. The penalty function
consists of a \emph{penalty parameter} multiplied by a measure of violation of the constraints. The penalty
parameter is multiplied by a scale factor (see \code{penalty_scale}) at every iteration;
\item \code{"BARRIER"} - Barrier Method: the value of the objective function is set equal to an arbitrary large
positive (or negative in case of maximization) number if any of the constraints is violated;
\item \code{"ACCREJ"} - Acceptance-Rejection method: a solution violating any of the constraints is replaced by a
randomly generated new one in the feasible region.
Default is \code{"PENALTY"}.
}}

\item{\code{penalty_scale}}{scale factor for the \emph{penalty parameter} at each iteration. It should
be greater than 1. Default is 10.}

\item{\code{start_penalty_param}}{initial value of the \emph{penalty parameter}. It should
be greater than 0. Default is 2.}

\item{\code{max_penalty_param}}{maximum value for the \emph{penalty parameter}. It should
be greater than 0. Default is 1.e+10.}

\item{\code{constr_init_pop}}{if \code{TRUE} the initial population is generated in the \emph{feasible region} only.
Default is \code{TRUE}.}

\item{\code{oob_solutions}}{strategy to treat out-of-bound solutions. Possible values are:
\itemize{
\item \code{"RBC"} - Reflective Boundary Condition: the solution is placed back inside the search domain
at a position which is distanced from the boundary as the out-of-bound excess. Depending on the
optimization algorithm, the velocity of the corresponding individual of the population could be
also inverted;
\item \code{"PBC"} - Periodic Boundary Condition: the solution is placed back inside the search domain
at a position which is distanced from the \emph{opposite} boundary as the out-of-bound excess;
\item \code{"BAB"} - Back At Boundary: the solution is placed back at the boundaries for the out-of-bound
dimensions;
\item \code{"DIS"} - Disregard the solution: the solution is replaced by a new one, which is randomly
generated in the search space.
Default is \code{"DIS"}.
}}

\item{\code{seed}}{seed for the internal random number generator. Accepted values are strictly positive integers.
If \code{NULL} a random seed at each execution is used. Default is \code{NULL}.}

\item{\code{initial_population}}{manually specify the position of the initial population. A
\mjeqn{n \times d}{n x d} matrix has to be provided, where \mjeqn{n}{n} is the population size
and \mjeqn{d}{d} is the number of parameters the objective function is minimized with respect to.}
}}

