% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plots.R
\name{plotCiCalibrationEffect}
\alias{plotCiCalibrationEffect}
\title{Plot the effect of the CI calibration}
\usage{
plotCiCalibrationEffect(
  logRr,
  seLogRr,
  trueLogRr,
  legacy = FALSE,
  model = NULL,
  xLabel = "Relative risk",
  title,
  fileName = NULL
)
}
\arguments{
\item{logRr}{A numeric vector of effect estimates on the log scale.}

\item{seLogRr}{The standard error of the log of the effect estimates. Hint: often the standard
error = (log(<lower bound 95 percent confidence interval>) - log(<effect
estimate>))/qnorm(0.025).}

\item{trueLogRr}{A vector of the true effect sizes.}

\item{legacy}{If true, a legacy error model will be fitted, meaning standard 
deviation is linear on the log scale. If false, standard deviation
is assumed to be simply linear.}

\item{model}{The fitted systematic error model. If not provided, it will be fitted on the
provided data.}

\item{xLabel}{The label on the x-axis: the name of the effect estimate.}

\item{title}{Optional: the main title for the plot}

\item{fileName}{Name of the file where the plot should be saved, for example 'plot.png'. See the
function \code{ggsave} in the ggplot2 package for supported file formats.}
}
\value{
A Ggplot object. Use the \code{ggsave} function to save to file.
}
\description{
Creates a plot with the effect estimate on the x-axis and the standard error on the y-axis. The plot
is trellised by true effect size. Negative and positive controls are shown as blue dots. The area below the
dashed line indicated estimates that are statistically significant different from the true effect size (p < 0.05). 
The orange area indicates estimates with calibrated p < 0.05.
}
\examples{
data <- simulateControls(n = 50 * 3, mean = 0.25, sd = 0.25, trueLogRr = log(c(1, 2, 4)))
plotCiCalibrationEffect(data$logRr, data$seLogRr, data$trueLogRr)

}
