% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aso_freq_function_repeated.R
\name{freq_function_repeated}
\alias{freq_function_repeated}
\title{Wrapper for \code{freq_function()} to get frequencies for many variables in one
go.}
\usage{
freq_function_repeated(
  normaldata,
  var1,
  var2 = NULL,
  by_vars = NULL,
  include_NA = FALSE,
  values_to_remove = NULL,
  weightvar = NULL,
  textvar = NULL,
  number_decimals = 2,
  output = c("all", "numeric", "col", "colw", "row", "roww", "total", "totalw"),
  chisquare = FALSE
)
}
\arguments{
\item{normaldata}{A data frame or data frame extension (e.g. a tibble).}

\item{var1}{A character vector with the names of the first variable to get
frequencies from for each frequency table.}

\item{var2}{An optional character naming the second variable to get
frequencies. If \code{NULL} (standard) 1-way frequency tables of only variables
in \code{var1} are created, and if \code{var2} is specified 2-way tables are
returned.}

\item{by_vars}{An optional character vector naming variables in \code{normal_data}
to stratify the calculations and output by. That is, ALL calculations will
be made within the combinations of variables in the vector, hence it's
possible to get N and \% for many groups in one go.}

\item{include_NA}{A logical. If \code{FALSE} (standard) missing variables (\code{NA}'s)
will be removed from \code{var1} and \code{var2}. Any missing values in \code{by_vars}
will not be removed. If \code{TRUE} all missing values will be included in
calculations and the output.}

\item{values_to_remove}{An optional character vector. When specified all
values from \code{var1} and \code{var2} found in \code{values_to_remove} will be removed
from the calculations and output.}

\item{weightvar}{An optional character naming a column in \code{normaldata} with
numeric weights for each observation. If \code{NULL} (standard) all observations
have weight 1.}

\item{textvar}{An optional character. When specified \code{textvar} is added to
the resulting table as a comment. When \code{NULL} (standard) no such text
addition is made.}

\item{number_decimals}{A numeric indicating the number of decimals to show on
percentages and weighted frequencies in the combined frequency and percent
variables.}

\item{output}{A character indicating the output type wanted:
\itemize{
\item \code{"all"} - will give ALL output from tables. In many cases unnecessary and
hard to get an overview of. This is set as the standard.
\item \code{"numeric"} - will give frequencies and percents as numeric variables
only, thus the number_decimals option is not in effect. This option might
be useful when making figures/graphs.
\item "col" - will only give unweighted number of observations and weighted
column percent (if weights are used, otherwise unweighted)
\item \code{"colw"} - will only give weighted number of observations and weighted
column percent (if weights are used, otherwise unweighted)
\item \code{"row"}- will only give unweighted number of observations and weighted
row percent (if weights are used, otherwise unweighted). Only works in
two-way tables (\code{var2} is specified)
\item \code{"roww"} - will only give weighted number of oberservations and weighted
column percent (if weights are used, otherwise unweighted). Only works in
two-way tables (\code{var2} is specified)
\item \code{"total"} - will only give unweighted number of observations and
weighted percent of the total (if weights are used, otherwise unweighted).
Only works in two-way tables (\code{var2} is specified)
\item \code{"totalw"} - will only give weighted number of observations and
weighted percent of the total (if weights are used, otherwise unweighted).
Only works in two-way tables (\code{var2} is specified)
\item Any other text will give the default ("all")
}}

\item{chisquare}{A logical. \code{FALSE} (standard) will not calculate p-value for
the chi-square test for two-way tables (\code{var2} is specified). If \code{TRUE},
the table will include the chi-square p-value as well as the chi-square
statistic and the corresponding degrees of freedom. It will be included in
the output whichever output option have been specified. No chi-square test
is performed or included in one-way tables (\code{var2} is unspecified)}
}
\value{
Multiple frequency tables stored in a data frame object.
}
\description{
A method for making multiple 1- and 2-way frequency tables with percentages
and odds ratios.
}
\examples{
# Examples
data("starwars", package = "dplyr")
test_table1 <- freq_function_repeated(
  starwars,
  var1 = c("sex","homeworld","eye_color"),
  include_NA = TRUE
)
test_table2 <- freq_function_repeated(
  starwars,
  var1 = c("homeworld","eye_color","skin_color"),
  var2 = "sex",
  output = "col",
  number_decimals = 3
)
test_table3 <- freq_function_repeated(
  starwars,
  var1 = c("homeworld","eye_color","skin_color"),
  var2 = "sex",
  by_vars = c("gender"),
  output = "row"
)

}
\seealso{
\code{\link[=freq_function]{freq_function()}} for the function that creates frequency tables for
single variables.
}
\author{
ASO
}
