% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adls_try_catch_warnings.R
\name{try_catch_warnings}
\alias{try_catch_warnings}
\title{Try Catch with Warning Handling}
\usage{
try_catch_warnings(expr, character = FALSE)
}
\arguments{
\item{expr}{An expression to be evaluated.}

\item{character}{A logical indicating if the returned error and warning
should be characters (\code{character} = \code{TRUE}) or language
(\code{character} = \code{FALSE}).}
}
\value{
The \code{try_catch_warnings()} funciton returns a list with three elements
\itemize{
\item \code{values} is the evaluated \code{expr} or \code{NULL} if the evaluations throws an
error.
\item \code{warning} is any warning given while evaluating \code{expr}. When \code{character} =
\code{FALSE}, the default, \code{warning} is a \link[base]{simpleWarning}, otherwise
it is a character.
\item \code{error} is any error given while trying to evaluate \code{expr}. When
\code{character} = \code{FALSE}, the default, \code{error} is a \link[base]{simpleError},
otherwise it is a character.
}
}
\description{
Try Catch with Warning Handling
}
\examples{
# No errors or warnings
try_catch_warnings(log(2))

# Warnings
try_catch_warnings(log(-1))

# Errors
try_catch_warnings(stop("Error Message"))
try_catch_warnings(stop("Error Message"), character = TRUE)

}
