% Generated by roxygen2 (4.0.1): do not edit by hand
\name{color_tea}
\alias{color_tea}
\title{Creates a TEA Variable for Infection Status for \code{ndtv} Animations}
\usage{
color_tea(nd, old.var = "testatus", old.sus = 0, old.inf = 1,
  old.rec = 2, new.var = "ndtvcol", new.sus, new.inf, new.rec,
  verbose = TRUE)
}
\arguments{
\item{nd}{an object of class \code{networkDynamic}.}

\item{old.var}{old TEA variable name.}

\item{old.sus}{status value for susceptible in old TEA variable.}

\item{old.inf}{status value for infected in old TEA variable.}

\item{old.rec}{status value for recovered in old TEA variable.}

\item{new.var}{new TEA variable name to be stored in \code{networkDynamic}
object.}

\item{new.sus}{status value for susceptible in new TEA variable.}

\item{new.inf}{status value for infected in new TEA variable.}

\item{new.rec}{status value for recovered in new TEA variable.}

\item{verbose}{print progress to console.}
}
\description{
Creates a new color-named temporally-extended attribute (TEA)
             variable in a \code{networkDynamic} object containing a disease
             status TEA in numeric format.
}
\details{
The \code{ndtv} package (\url{http://cran.r-project.org/package=ndtv}) produces
animated visuals for dynamic networks with evolving edge structures and nodal
attributes. Nodal attribute dynamics in \code{ndtv} movies require a temporally
extended attribute (TEA) containing a standard R color for each node at each
time step. By default, the \code{EpiModel} package uses TEAs to store disease
status history in network model simulations run in \code{\link{netsim}}. But
that status TEA is in numeric format (0, 1, 2). The \code{color_tea} function
transforms those numeric values of that disease status TEA into a TEA with
color values in order to visualize status changes in \code{ndtv}.

The convention in \code{\link{plot.netsim}} is to color the susceptible
nodes as blue, infected nodes as red, and recovered nodes as green. Alternate
colors may be specified using the \code{new.sus}, \code{new.inf}, and
\code{new.rec} parameters, respectively.

Using the \code{color_tea} function with a \code{netsim} object requires that
TEAs for disease status be used and that the \code{networkDynamic} object be
saved in the output: both \code{tea.status} and \code{save.network} must be
set to \code{TRUE} in \code{\link{control.net}}.
}
\seealso{
\code{\link{netsim}} and the \code{ndtv} package documentation.
}
\keyword{colorUtils}

